/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.crypto.Encryptor;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CommonsCryptoAESEncryptor
implements Encryptor {
    private String cipherMode;
    private Properties properties;
    private Key key;
    private byte[] iv;
    private boolean initialized = false;
    private SecureRandom rng;

    public CommonsCryptoAESEncryptor(String cipherMode, Properties properties, SecureRandom rng) {
        this.cipherMode = cipherMode;
        this.properties = properties;
        this.rng = rng;
    }

    @Override
    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public void setIv(byte[] iv) {
        Preconditions.checkNotNull((Object)iv, (Object)"IV cannot be null");
        Preconditions.checkArgument((iv.length == 16 ? 1 : 0) != 0, (Object)"Invalid IV length");
        this.iv = iv;
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out) {
        if (!this.initialized) {
            this.reset();
        }
        try {
            return new CryptoOutputStream(this.cipherMode, this.properties, out, this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        if (this.iv == null) {
            this.iv = new byte[this.getIvLength()];
            this.rng.nextBytes(this.iv);
        }
        this.initialized = true;
    }
}

