/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class NoneEncoder {
    private DataOutputStream out;
    private HFileBlockDefaultEncodingContext encodingCtx;

    public NoneEncoder(DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) {
        this.out = out;
        this.encodingCtx = encodingCtx;
    }

    public int write(Cell cell) throws IOException {
        int size = KeyValueUtil.oswrite(cell, this.out, false);
        if (this.encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            this.out.writeShort(tagsLength);
            if (tagsLength > 0) {
                CellUtil.writeTags(this.out, cell, tagsLength);
            }
            size += tagsLength + 2;
        }
        if (this.encodingCtx.getHFileContext().isIncludesMvcc()) {
            WritableUtils.writeVLong((DataOutput)this.out, (long)cell.getSequenceId());
            size += WritableUtils.getVIntSize((long)cell.getSequenceId());
        }
        return size;
    }
}

