/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
public class OrderedFloat32
extends OrderedBytesBase<Float> {
    public static final OrderedFloat32 ASCENDING = new OrderedFloat32(Order.ASCENDING);
    public static final OrderedFloat32 DESCENDING = new OrderedFloat32(Order.DESCENDING);

    protected OrderedFloat32(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Float val) {
        return 5;
    }

    @Override
    public Class<Float> encodedClass() {
        return Float.class;
    }

    @Override
    public Float decode(PositionedByteRange src) {
        return Float.valueOf(OrderedBytes.decodeFloat32(src));
    }

    @Override
    public int encode(PositionedByteRange dst, Float val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeFloat32(dst, val.floatValue(), this.order);
    }

    public float decodeFloat(PositionedByteRange dst) {
        return OrderedBytes.decodeFloat32(dst);
    }

    public int encodeFloat(PositionedByteRange dst, float val) {
        return OrderedBytes.encodeFloat32(dst, val, this.order);
    }
}

