/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
public class StructIterator
implements Iterator<Object> {
    protected final PositionedByteRange src;
    protected int idx = 0;
    protected final DataType[] types;

    public StructIterator(PositionedByteRange src, DataType[] types) {
        this.src = src;
        this.types = types;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.types.length && this.src.getPosition() <= this.src.getLength();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DataType t = this.types[this.idx++];
        if (this.src.getPosition() == this.src.getLength() && t.isNullable()) {
            return null;
        }
        return t.decode(this.src);
    }

    public int skip() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DataType t = this.types[this.idx++];
        if (this.src.getPosition() == this.src.getLength() && t.isNullable()) {
            return 0;
        }
        return t.skip(this.src);
    }
}

