/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class CollectionUtils {
    private static final List<Object> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));

    public static <T> Collection<T> nullSafe(Collection<T> in) {
        if (in == null) {
            return EMPTY_LIST;
        }
        return in;
    }

    public static <T> int nullSafeSize(Collection<T> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static <A, B> boolean nullSafeSameSize(Collection<A> a, Collection<B> b) {
        return CollectionUtils.nullSafeSize(a) == CollectionUtils.nullSafeSize(b);
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean notEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    public static int getLastIndex(List<?> list) {
        if (CollectionUtils.isEmpty(list)) {
            return -1;
        }
        return list.size() - 1;
    }

    public static boolean isLastIndex(List<?> list, int index) {
        return index == CollectionUtils.getLastIndex(list);
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Supplier<V> supplier) {
        return CollectionUtils.computeIfAbsent(map, key, supplier, () -> {});
    }

    public static <K, V> V computeIfAbsentEx(ConcurrentMap<K, V> map, K key, IOExceptionSupplier<V> supplier) throws IOException {
        V newValue;
        Object v = map.get(key);
        return v == null && (newValue = supplier.get()) != null && (v = map.putIfAbsent(key, newValue)) == null ? newValue : v;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Supplier<V> supplier, Runnable actionIfAbsent) {
        Object v = map.get(key);
        if (v != null) {
            return v;
        }
        V newValue = supplier.get();
        v = map.putIfAbsent(key, newValue);
        if (v != null) {
            return v;
        }
        actionIfAbsent.run();
        return newValue;
    }

    @FunctionalInterface
    public static interface IOExceptionSupplier<V> {
        public V get() throws IOException;
    }
}

