/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.ByteBufferWriterDataOutputStream;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTagCompressionContext {
    private static final byte[] ROW = Bytes.toBytes((String)"r1");
    private static final byte[] CF = Bytes.toBytes((String)"f");
    private static final byte[] Q = Bytes.toBytes((String)"q");
    private static final byte[] V = Bytes.toBytes((String)"v");

    @Test
    public void testCompressUncompressTags1() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        KeyValue kv1 = this.createKVWithTags(2);
        int tagsLength1 = kv1.getTagsLength();
        ByteBuffer ib = ByteBuffer.wrap(kv1.getTagsArray());
        context.compressTags((OutputStream)baos, ib, kv1.getTagsOffset(), tagsLength1);
        KeyValue kv2 = this.createKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        ib = ByteBuffer.wrap(kv2.getTagsArray());
        context.compressTags((OutputStream)baos, ib, kv2.getTagsOffset(), tagsLength2);
        context.clear();
        byte[] dest = new byte[tagsLength1];
        ByteBuffer ob = ByteBuffer.wrap(baos.toByteArray());
        context.uncompressTags((ByteBuff)new SingleByteBuff(ob), dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv1.getTagsArray(), (int)kv1.getTagsOffset(), (int)tagsLength1, (byte[])dest, (int)0, (int)tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags((ByteBuff)new SingleByteBuff(ob), dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv2.getTagsArray(), (int)kv2.getTagsOffset(), (int)tagsLength2, (byte[])dest, (int)0, (int)tagsLength2));
    }

    @Test
    public void testCompressUncompressTagsWithOffheapKeyValue1() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBufferWriterDataOutputStream daos = new ByteBufferWriterDataOutputStream((OutputStream)baos);
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        ByteBufferExtendedCell kv1 = (ByteBufferExtendedCell)this.createOffheapKVWithTags(2);
        int tagsLength1 = kv1.getTagsLength();
        context.compressTags((OutputStream)daos, kv1.getTagsByteBuffer(), kv1.getTagsPosition(), tagsLength1);
        ByteBufferExtendedCell kv2 = (ByteBufferExtendedCell)this.createOffheapKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        context.compressTags((OutputStream)daos, kv2.getTagsByteBuffer(), kv2.getTagsPosition(), tagsLength2);
        context.clear();
        byte[] dest = new byte[tagsLength1];
        ByteBuffer ob = ByteBuffer.wrap(baos.getBuffer());
        context.uncompressTags((ByteBuff)new SingleByteBuff(ob), dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv1.getTagsArray(), (int)kv1.getTagsOffset(), (int)tagsLength1, (byte[])dest, (int)0, (int)tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags((ByteBuff)new SingleByteBuff(ob), dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv2.getTagsArray(), (int)kv2.getTagsOffset(), (int)tagsLength2, (byte[])dest, (int)0, (int)tagsLength2));
    }

    @Test
    public void testCompressUncompressTags2() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        KeyValue kv1 = this.createKVWithTags(1);
        int tagsLength1 = kv1.getTagsLength();
        context.compressTags((OutputStream)baos, kv1.getTagsArray(), kv1.getTagsOffset(), tagsLength1);
        KeyValue kv2 = this.createKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        context.compressTags((OutputStream)baos, kv2.getTagsArray(), kv2.getTagsOffset(), tagsLength2);
        context.clear();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.getBuffer());
        byte[] dest = new byte[tagsLength1];
        context.uncompressTags((InputStream)bais, dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv1.getTagsArray(), (int)kv1.getTagsOffset(), (int)tagsLength1, (byte[])dest, (int)0, (int)tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags((InputStream)bais, dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv2.getTagsArray(), (int)kv2.getTagsOffset(), (int)tagsLength2, (byte[])dest, (int)0, (int)tagsLength2));
    }

    @Test
    public void testCompressUncompressTagsWithOffheapKeyValue2() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBufferWriterDataOutputStream daos = new ByteBufferWriterDataOutputStream((OutputStream)baos);
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        ByteBufferExtendedCell kv1 = (ByteBufferExtendedCell)this.createOffheapKVWithTags(1);
        int tagsLength1 = kv1.getTagsLength();
        context.compressTags((OutputStream)daos, kv1.getTagsByteBuffer(), kv1.getTagsPosition(), tagsLength1);
        ByteBufferExtendedCell kv2 = (ByteBufferExtendedCell)this.createOffheapKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        context.compressTags((OutputStream)daos, kv2.getTagsByteBuffer(), kv2.getTagsPosition(), tagsLength2);
        context.clear();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.getBuffer());
        byte[] dest = new byte[tagsLength1];
        context.uncompressTags((InputStream)bais, dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv1.getTagsArray(), (int)kv1.getTagsOffset(), (int)tagsLength1, (byte[])dest, (int)0, (int)tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags((InputStream)bais, dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv2.getTagsArray(), (int)kv2.getTagsOffset(), (int)tagsLength2, (byte[])dest, (int)0, (int)tagsLength2));
    }

    private KeyValue createKVWithTags(int noOfTags) {
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>();
        for (int i = 0; i < noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, "tagValue" + i));
        }
        KeyValue kv = new KeyValue(ROW, CF, Q, 1234L, V, tags);
        return kv;
    }

    private Cell createOffheapKVWithTags(int noOfTags) {
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>();
        for (int i = 0; i < noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, "tagValue" + i));
        }
        KeyValue kv = new KeyValue(ROW, CF, Q, 1234L, V, tags);
        ByteBuffer dbb = ByteBuffer.allocateDirect(kv.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)dbb, (byte[])kv.getBuffer(), (int)0, (int)kv.getBuffer().length);
        ByteBufferKeyValue offheapKV = new ByteBufferKeyValue(dbb, 0, kv.getBuffer().length, 0L);
        return offheapKV;
    }
}

