/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.Context;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCipherProvider {
    @Test
    public void testCustomProvider() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.crypto.cipherprovider", MyCipherProvider.class.getName());
        CipherProvider provider = Encryption.getCipherProvider((Configuration)conf);
        Assert.assertTrue((boolean)(provider instanceof MyCipherProvider));
        Assert.assertTrue((boolean)Arrays.asList(provider.getSupportedCiphers()).contains("TEST"));
        Cipher a = Encryption.getCipher((Configuration)conf, (String)"TEST");
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a.getProvider() instanceof MyCipherProvider));
        Assert.assertEquals((Object)"TEST", (Object)a.getName());
        Assert.assertEquals((long)0L, (long)a.getKeyLength());
    }

    @Test
    public void testDefaultProvider() {
        Configuration conf = HBaseConfiguration.create();
        CipherProvider provider = Encryption.getCipherProvider((Configuration)conf);
        Assert.assertTrue((boolean)(provider instanceof DefaultCipherProvider));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Assert.assertTrue((boolean)Arrays.asList(provider.getSupportedCiphers()).contains(algorithm));
        Cipher a = Encryption.getCipher((Configuration)conf, (String)algorithm);
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a.getProvider() instanceof DefaultCipherProvider));
        Assert.assertEquals((Object)a.getName(), (Object)algorithm);
        Assert.assertEquals((long)16L, (long)a.getKeyLength());
    }

    public static class MyCipherProvider
    implements CipherProvider {
        private Configuration conf;

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public String getName() {
            return MyCipherProvider.class.getName();
        }

        public String[] getSupportedCiphers() {
            return new String[]{"TEST"};
        }

        public Cipher getCipher(String name) {
            if (name.equals("TEST")) {
                return new Cipher(this){

                    public String getName() {
                        return "TEST";
                    }

                    public int getKeyLength() {
                        return 0;
                    }

                    public int getIvLength() {
                        return 0;
                    }

                    public Key getRandomKey() {
                        return null;
                    }

                    public Encryptor getEncryptor() {
                        return null;
                    }

                    public Decryptor getDecryptor() {
                        return null;
                    }

                    public OutputStream createEncryptionStream(OutputStream out, Context context, byte[] iv) throws IOException {
                        return null;
                    }

                    public OutputStream createEncryptionStream(OutputStream out, Encryptor encryptor) throws IOException {
                        return null;
                    }

                    public InputStream createDecryptionStream(InputStream in, Context context, byte[] iv) throws IOException {
                        return null;
                    }

                    public InputStream createDecryptionStream(InputStream in, Decryptor decryptor) throws IOException {
                        return null;
                    }
                };
            }
            return null;
        }
    }
}

