/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestMultiByteBuff {
    @Test
    public void testWritesAndReads() {
        ByteBuffer bb1 = ByteBuffer.allocate(15);
        ByteBuffer bb2 = ByteBuffer.allocate(15);
        int i1 = 4;
        bb1.putInt(i1);
        long l1 = 45L;
        long l2 = 100L;
        long l3 = 12345L;
        bb1.putLong(l1);
        short s1 = 2;
        bb1.putShort(s1);
        byte[] b = Bytes.toBytes((long)l2);
        bb1.put(b, 0, 1);
        bb2.put(b, 1, 7);
        bb2.putLong(l3);
        MultiByteBuff mbb = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        Assert.assertEquals((long)l1, (long)mbb.getLong(4));
        Assert.assertEquals((long)l2, (long)mbb.getLong(14));
        Assert.assertEquals((long)l3, (long)mbb.getLong(22));
        Assert.assertEquals((long)i1, (long)mbb.getInt(0));
        Assert.assertEquals((long)s1, (long)mbb.getShort(12));
        Assert.assertEquals((long)i1, (long)mbb.getInt());
        Assert.assertEquals((long)l1, (long)mbb.getLong());
        Assert.assertEquals((long)s1, (long)mbb.getShort());
        Assert.assertEquals((long)l2, (long)mbb.getLong());
        Assert.assertEquals((long)l3, (long)mbb.getLong());
        bb1 = ByteBuffer.allocate(15);
        bb2 = ByteBuffer.allocate(15);
        mbb = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        byte b1 = 5;
        byte b2 = 31;
        mbb.put(b1);
        mbb.putLong(l1);
        mbb.putInt(i1);
        mbb.putLong(l2);
        mbb.put(b2);
        mbb.position(mbb.position() + 2);
        try {
            mbb.putLong(l3);
            Assert.fail((String)"'Should have thrown BufferOverflowException");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        mbb.position(mbb.position() - 2);
        mbb.putLong(l3);
        mbb.rewind();
        Assert.assertEquals((long)b1, (long)mbb.get());
        Assert.assertEquals((long)l1, (long)mbb.getLong());
        Assert.assertEquals((long)i1, (long)mbb.getInt());
        Assert.assertEquals((long)l2, (long)mbb.getLong());
        Assert.assertEquals((long)b2, (long)mbb.get());
        Assert.assertEquals((long)l3, (long)mbb.getLong());
        mbb.put(21, b1);
        mbb.position(21);
        Assert.assertEquals((long)b1, (long)mbb.get());
        mbb.put(b);
        Assert.assertEquals((long)l2, (long)mbb.getLong(22));
    }

    @Test
    public void testPutPrimitives() {
        ByteBuffer bb = ByteBuffer.allocate(10);
        SingleByteBuff s = new SingleByteBuff(bb);
        s.putLong(-4465109508325701663L);
        bb.rewind();
        long long1 = bb.getLong();
        Assert.assertEquals((long)-4465109508325701663L, (long)long1);
        s.position(8);
    }

    @Test
    public void testArrayBasedMethods() {
        byte[] b = new byte[15];
        ByteBuffer bb1 = ByteBuffer.wrap(b, 1, 10).slice();
        ByteBuffer bb2 = ByteBuffer.allocate(15);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        Assert.assertFalse((boolean)mbb1.hasArray());
        try {
            mbb1.array();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mbb1.arrayOffset();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        mbb1 = new SingleByteBuff(bb1);
        Assert.assertTrue((boolean)mbb1.hasArray());
        Assert.assertEquals((long)1L, (long)mbb1.arrayOffset());
        Assert.assertEquals((Object)b, (Object)mbb1.array());
        mbb1 = new SingleByteBuff(ByteBuffer.allocateDirect(10));
        Assert.assertFalse((boolean)mbb1.hasArray());
        try {
            mbb1.array();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mbb1.arrayOffset();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testMarkAndResetWithMBB() {
        ByteBuffer bb1 = ByteBuffer.allocateDirect(15);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(15);
        bb1.putInt(4);
        long l1 = 45L;
        long l2 = 100L;
        long l3 = 12345L;
        bb1.putLong(l1);
        bb1.putShort((short)2);
        byte[] b = Bytes.toBytes((long)l2);
        bb1.put(b, 0, 1);
        bb2.put(b, 1, 7);
        bb2.putLong(l3);
        MultiByteBuff multi = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        Assert.assertEquals((long)4L, (long)multi.getInt());
        Assert.assertEquals((long)l1, (long)multi.getLong());
        multi.mark();
        Assert.assertEquals((long)2L, (long)multi.getShort());
        multi.reset();
        Assert.assertEquals((long)2L, (long)multi.getShort());
        multi.mark();
        Assert.assertEquals((long)l2, (long)multi.getLong());
        multi.reset();
        Assert.assertEquals((long)l2, (long)multi.getLong());
        multi.mark();
        Assert.assertEquals((long)l3, (long)multi.getLong());
        multi.reset();
        Assert.assertEquals((long)l3, (long)multi.getLong());
        multi.mark();
        Assert.assertEquals((long)l2, (long)multi.getLong(14));
        multi.reset();
        Assert.assertEquals((long)l3, (long)multi.getLong(22));
        multi.reset();
        Assert.assertEquals((long)l2, (long)multi.getLong(14));
        multi.mark();
        Assert.assertEquals((long)l3, (long)multi.getLong(22));
        multi.reset();
    }

    @Test
    public void testSkipNBytes() {
        ByteBuffer bb1 = ByteBuffer.allocate(15);
        ByteBuffer bb2 = ByteBuffer.allocate(15);
        bb1.putInt(4);
        long l1 = 45L;
        long l2 = 100L;
        long l3 = 12345L;
        bb1.putLong(l1);
        bb1.putShort((short)2);
        byte[] b = Bytes.toBytes((long)l2);
        bb1.put(b, 0, 1);
        bb2.put(b, 1, 7);
        bb2.putLong(l3);
        MultiByteBuff multi = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        Assert.assertEquals((long)4L, (long)multi.getInt());
        Assert.assertEquals((long)l1, (long)multi.getLong());
        multi.skip(10);
        Assert.assertEquals((long)l3, (long)multi.getLong());
    }

    @Test
    public void testMoveBack() {
        ByteBuffer bb1 = ByteBuffer.allocate(15);
        ByteBuffer bb2 = ByteBuffer.allocate(15);
        bb1.putInt(4);
        long l1 = 45L;
        long l2 = 100L;
        long l3 = 12345L;
        bb1.putLong(l1);
        bb1.putShort((short)2);
        byte[] b = Bytes.toBytes((long)l2);
        bb1.put(b, 0, 1);
        bb2.put(b, 1, 7);
        bb2.putLong(l3);
        MultiByteBuff multi = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        Assert.assertEquals((long)4L, (long)multi.getInt());
        Assert.assertEquals((long)l1, (long)multi.getLong());
        multi.skip(10);
        multi.moveBack(4);
        multi.moveBack(6);
        multi.moveBack(8);
        Assert.assertEquals((long)l1, (long)multi.getLong());
    }

    @Test
    public void testSubBuffer() {
        ByteBuffer bb1 = ByteBuffer.allocateDirect(10);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(10);
        MultiByteBuff multi = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        long l1 = 1234L;
        long l2 = 100L;
        multi.putLong(l1);
        multi.putLong(l2);
        multi.rewind();
        ByteBuffer sub = multi.asSubByteBuffer(8);
        Assert.assertEquals((Object)bb1, (Object)sub);
        Assert.assertEquals((long)l1, (long)ByteBufferUtils.toLong((ByteBuffer)sub, (int)sub.position()));
        multi.skip(8);
        sub = multi.asSubByteBuffer(8);
        Assert.assertNotEquals((Object)bb1, (Object)sub);
        Assert.assertNotEquals((Object)bb2, (Object)sub);
        Assert.assertEquals((long)l2, (long)ByteBufferUtils.toLong((ByteBuffer)sub, (int)sub.position()));
        multi.rewind();
        ObjectIntPair p = new ObjectIntPair();
        multi.asSubByteBuffer(8, 8, p);
        Assert.assertNotEquals((Object)bb1, (Object)p.getFirst());
        Assert.assertNotEquals((Object)bb2, (Object)p.getFirst());
        Assert.assertEquals((long)0L, (long)p.getSecond());
        Assert.assertEquals((long)l2, (long)ByteBufferUtils.toLong((ByteBuffer)sub, (int)p.getSecond()));
    }

    @Test
    public void testSliceDuplicateMethods() throws Exception {
        ByteBuffer bb1 = ByteBuffer.allocateDirect(10);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(15);
        MultiByteBuff multi = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        long l1 = 1234L;
        long l2 = 100L;
        multi.put((byte)2);
        multi.putLong(l1);
        multi.putLong(l2);
        multi.putInt(45);
        multi.position(1);
        multi.limit(multi.position() + 16);
        MultiByteBuff sliced = multi.slice();
        Assert.assertEquals((long)0L, (long)sliced.position());
        Assert.assertEquals((long)16L, (long)sliced.limit());
        Assert.assertEquals((long)l1, (long)sliced.getLong());
        Assert.assertEquals((long)l2, (long)sliced.getLong());
        MultiByteBuff dup = multi.duplicate();
        Assert.assertEquals((long)1L, (long)dup.position());
        Assert.assertEquals((long)(dup.position() + 16), (long)dup.limit());
        Assert.assertEquals((long)l1, (long)dup.getLong());
        Assert.assertEquals((long)l2, (long)dup.getLong());
    }

    @Test
    public void testGetWithPosOnMultiBuffers() throws IOException {
        byte[] b = new byte[4];
        byte[] b1 = new byte[4];
        ByteBuffer bb1 = ByteBuffer.wrap(b);
        ByteBuffer bb2 = ByteBuffer.wrap(b1);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        mbb1.position(2);
        mbb1.putInt(4);
        int res = mbb1.getInt(2);
        byte[] bres = new byte[]{mbb1.get(2), mbb1.get(3), mbb1.get(4), mbb1.get(5)};
        int expected = Bytes.toInt((byte[])bres);
        Assert.assertEquals((long)expected, (long)res);
    }

    @Test
    public void testGetIntStrictlyForwardWithPosOnMultiBuffers() throws IOException {
        byte[] b = new byte[4];
        byte[] b1 = new byte[8];
        ByteBuffer bb1 = ByteBuffer.wrap(b);
        ByteBuffer bb2 = ByteBuffer.wrap(b1);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        mbb1.position(2);
        mbb1.putInt(4);
        mbb1.position(7);
        mbb1.put((byte)2);
        mbb1.putInt(3);
        mbb1.rewind();
        mbb1.getIntAfterPosition(4);
        byte res = mbb1.get(7);
        Assert.assertEquals((long)2L, (long)res);
        mbb1.position(7);
        int intRes = mbb1.getIntAfterPosition(1);
        Assert.assertEquals((long)3L, (long)intRes);
    }

    @Test
    public void testPositonalCopyToByteArray() throws Exception {
        byte[] b = new byte[4];
        byte[] b1 = new byte[8];
        ByteBuffer bb1 = ByteBuffer.wrap(b);
        ByteBuffer bb2 = ByteBuffer.wrap(b1);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        mbb1.position(2);
        mbb1.putInt(4);
        mbb1.position(7);
        mbb1.put((byte)2);
        mbb1.putInt(3);
        byte[] dst = new byte[4];
        mbb1.get(2, dst, 0, 4);
        Assert.assertEquals((long)4L, (long)Bytes.toInt((byte[])dst));
        Assert.assertEquals((long)12L, (long)mbb1.position());
        mbb1.position(1);
        dst = new byte[4];
        mbb1.get(8, dst, 0, 4);
        Assert.assertEquals((long)3L, (long)Bytes.toInt((byte[])dst));
        Assert.assertEquals((long)1L, (long)mbb1.position());
        mbb1.position(12);
        dst = new byte[1];
        mbb1.get(7, dst, 0, 1);
        Assert.assertEquals((long)2L, (long)dst[0]);
        Assert.assertEquals((long)12L, (long)mbb1.position());
    }

    @Test
    public void testToBytes() throws Exception {
        int i;
        byte[] b = new byte[4];
        byte[] b1 = new byte[8];
        for (i = 0; i < b.length; ++i) {
            b[i] = (byte)i;
        }
        for (i = 0; i < b1.length; ++i) {
            b1[i] = (byte)(b1.length + i);
        }
        ByteBuffer bb1 = ByteBuffer.wrap(b);
        ByteBuffer bb2 = ByteBuffer.wrap(b1);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        byte[] actual = mbb1.toBytes(6, 4);
        Assert.assertTrue((boolean)Bytes.equals((byte[])actual, (int)0, (int)actual.length, (byte[])b1, (int)2, (int)4));
        actual = mbb1.toBytes(5, 7);
        Assert.assertTrue((boolean)Bytes.equals((byte[])actual, (int)0, (int)actual.length, (byte[])b1, (int)1, (int)7));
        actual = mbb1.toBytes(2, 7);
        byte[] expected = new byte[7];
        System.arraycopy(b, 2, expected, 0, 2);
        System.arraycopy(b1, 0, expected, 2, 5);
        Assert.assertTrue((boolean)Bytes.equals((byte[])actual, (byte[])expected));
        actual = mbb1.toBytes(1, 3);
        Assert.assertTrue((boolean)Bytes.equals((byte[])actual, (int)0, (int)actual.length, (byte[])b, (int)1, (int)3));
    }

    @Test
    public void testHasRemaining() {
        ByteBuffer b1 = ByteBuffer.allocate(8);
        ByteBuffer b2 = ByteBuffer.allocate(8);
        ByteBuffer b3 = ByteBuffer.allocate(8);
        MultiByteBuff mbb1 = new MultiByteBuff(new ByteBuffer[]{b1, b2, b3});
        Assert.assertTrue((boolean)mbb1.hasRemaining());
        mbb1.limit(20);
        mbb1.position(15);
        mbb1.get();
        Assert.assertTrue((boolean)mbb1.hasRemaining());
        mbb1.position(20);
        Assert.assertFalse((boolean)mbb1.hasRemaining());
        mbb1.limit(12);
        mbb1.position(11);
        Assert.assertTrue((boolean)mbb1.hasRemaining());
        mbb1.get();
        Assert.assertFalse((boolean)mbb1.hasRemaining());
        mbb1.limit(16);
        mbb1.position(15);
        Assert.assertTrue((boolean)mbb1.hasRemaining());
        mbb1.get();
        Assert.assertFalse((boolean)mbb1.hasRemaining());
    }
}

