/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.CopyOnWriteArrayMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCopyOnWriteMaps {
    private static final int MAX_RAND = 10000000;
    private ConcurrentNavigableMap<Long, Long> m;
    private ConcurrentSkipListMap<Long, Long> csm;

    @Before
    public void setUp() {
        this.m = new CopyOnWriteArrayMap();
        this.csm = new ConcurrentSkipListMap();
        for (long i = 0L; i < 10000L; ++i) {
            long o = ThreadLocalRandom.current().nextLong(10000000L);
            this.m.put(i, o);
            this.csm.put(i, o);
        }
        long o = ThreadLocalRandom.current().nextLong(10000000L);
        this.m.put(0L, o);
        this.csm.put(0L, o);
    }

    @Test
    public void testSize() throws Exception {
        Assert.assertEquals((String)"Size should always be equal", (long)this.m.size(), (long)this.csm.size());
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.m.clear();
        Assert.assertTrue((boolean)this.m.isEmpty());
        this.m.put(100L, 100L);
        Assert.assertFalse((boolean)this.m.isEmpty());
        this.m.remove(100L);
        Assert.assertTrue((boolean)this.m.isEmpty());
    }

    @Test
    public void testFindOnEmpty() throws Exception {
        this.m.clear();
        Assert.assertTrue((boolean)this.m.isEmpty());
        Assert.assertNull(this.m.get(100L));
        Assert.assertFalse((boolean)this.m.containsKey(100L));
        Assert.assertEquals((long)0L, (long)this.m.tailMap((Object)100L).entrySet().size());
    }

    @Test
    public void testLowerKey() throws Exception {
        Assert.assertEquals((Object)this.csm.lowerKey(400L), (Object)this.m.lowerKey(400L));
        Assert.assertEquals((Object)this.csm.lowerKey(-1L), (Object)this.m.lowerKey(-1L));
        for (int i = 0; i < 100; ++i) {
            Long key = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.lowerKey(key), (Object)this.m.lowerKey(key));
        }
    }

    @Test
    public void testFloorEntry() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Long key = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals(this.csm.floorEntry(key), this.m.floorEntry(key));
        }
    }

    @Test
    public void testFloorKey() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Long key = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.floorKey(key), (Object)this.m.floorKey(key));
        }
    }

    @Test
    public void testCeilingKey() throws Exception {
        Assert.assertEquals((Object)this.csm.ceilingKey(4000L), (Object)this.m.ceilingKey(4000L));
        Assert.assertEquals((Object)this.csm.ceilingKey(400L), (Object)this.m.ceilingKey(400L));
        Assert.assertEquals((Object)this.csm.ceilingKey(-1L), (Object)this.m.ceilingKey(-1L));
        for (int i = 0; i < 100; ++i) {
            Long key = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.ceilingKey(key), (Object)this.m.ceilingKey(key));
        }
    }

    @Test
    public void testHigherKey() throws Exception {
        Assert.assertEquals((Object)this.csm.higherKey(4000L), (Object)this.m.higherKey(4000L));
        Assert.assertEquals((Object)this.csm.higherKey(400L), (Object)this.m.higherKey(400L));
        Assert.assertEquals((Object)this.csm.higherKey(-1L), (Object)this.m.higherKey(-1L));
        for (int i = 0; i < 100; ++i) {
            Long key = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.higherKey(key), (Object)this.m.higherKey(key));
        }
    }

    @Test
    public void testRemove() throws Exception {
        for (Map.Entry<Long, Long> e : this.csm.entrySet()) {
            Assert.assertEquals((Object)this.csm.remove(e.getKey()), this.m.remove(e.getKey()));
            Assert.assertEquals(null, this.m.remove(e.getKey()));
        }
    }

    @Test
    public void testReplace() throws Exception {
        for (Map.Entry<Long, Long> e : this.csm.entrySet()) {
            Long newValue = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.replace(e.getKey(), newValue), (Object)this.m.replace(e.getKey(), newValue));
        }
        Assert.assertEquals(null, (Object)this.m.replace(10000100L, ThreadLocalRandom.current().nextLong()));
    }

    @Test
    public void testReplace1() throws Exception {
        for (Map.Entry<Long, Long> e : this.csm.entrySet()) {
            Long newValue = ThreadLocalRandom.current().nextLong();
            Assert.assertEquals((Object)this.csm.replace(e.getKey(), e.getValue() + 1L, newValue), (Object)this.m.replace(e.getKey(), e.getValue() + 1L, newValue));
            Assert.assertEquals((Object)this.csm.replace(e.getKey(), e.getValue(), newValue), (Object)this.m.replace(e.getKey(), e.getValue(), newValue));
            Assert.assertEquals((Object)newValue, this.m.get(e.getKey()));
            Assert.assertEquals((Object)this.csm.get(e.getKey()), this.m.get(e.getKey()));
        }
        Assert.assertEquals(null, (Object)this.m.replace(10000100L, ThreadLocalRandom.current().nextLong()));
    }

    @Test
    public void testMultiAdd() throws InterruptedException {
        Thread[] threads = new Thread[10];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 5000; ++j) {
                        TestCopyOnWriteMaps.this.m.put(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
                    }
                }
            });
        }
        for (Thread thread1 : threads) {
            thread1.start();
        }
        for (Thread thread2 : threads) {
            thread2.join();
        }
    }

    @Test
    public void testFirstKey() throws Exception {
        Assert.assertEquals((Object)this.csm.firstKey(), this.m.firstKey());
    }

    @Test
    public void testLastKey() throws Exception {
        Assert.assertEquals((Object)this.csm.lastKey(), this.m.lastKey());
    }

    @Test
    public void testFirstEntry() throws Exception {
        Assert.assertEquals((Object)this.csm.firstEntry().getKey(), this.m.firstEntry().getKey());
        Assert.assertEquals((Object)this.csm.firstEntry().getValue(), this.m.firstEntry().getValue());
        Assert.assertEquals(this.csm.firstEntry(), this.m.firstEntry());
    }

    @Test
    public void testLastEntry() throws Exception {
        Assert.assertEquals((Object)this.csm.lastEntry().getKey(), this.m.lastEntry().getKey());
        Assert.assertEquals((Object)this.csm.lastEntry().getValue(), this.m.lastEntry().getValue());
        Assert.assertEquals(this.csm.lastEntry(), this.m.lastEntry());
    }

    @Test
    public void testKeys() throws Exception {
        for (Long key : this.csm.keySet()) {
            Assert.assertNotNull(this.m.get(key));
            Assert.assertNotNull(this.m.remove(key));
            Assert.assertNull(this.m.get(key));
        }
    }

    @Test
    public void testValues() throws Exception {
        for (Long value : this.m.values()) {
            Assert.assertTrue((boolean)this.csm.values().contains(value));
            Assert.assertTrue((boolean)this.m.containsValue(value));
        }
    }

    @Test
    public void testTailMap() throws Exception {
        SortedMap fromCsm = this.csm.tailMap((Object)50L);
        SortedMap fromM = this.m.tailMap((Object)50L);
        Assert.assertEquals((Object)fromCsm, (Object)fromM);
        for (Long value : this.m.keySet()) {
            Assert.assertEquals((Object)this.csm.tailMap((Object)value), (Object)this.m.tailMap((Object)value));
        }
        for (long i = 0L; i < 100L; ++i) {
            long o = ThreadLocalRandom.current().nextLong(10000000L);
            Assert.assertEquals((Object)this.csm.tailMap((Object)o), (Object)this.m.tailMap((Object)o));
        }
    }

    @Test
    public void testTailMapExclusive() throws Exception {
        this.m.clear();
        this.m.put(100L, 100L);
        this.m.put(101L, 101L);
        this.m.put(101L, 101L);
        this.m.put(103L, 103L);
        this.m.put(99L, 99L);
        this.m.put(102L, 102L);
        long n = 100L;
        CopyOnWriteArrayMap tm99 = (CopyOnWriteArrayMap)this.m.tailMap((Object)99L, false);
        for (Map.Entry e : tm99.entrySet()) {
            Assert.assertEquals((Object)n, e.getKey());
            Assert.assertEquals((Object)n, e.getValue());
            ++n;
        }
    }

    @Test
    public void testTailMapInclusive() throws Exception {
        this.m.clear();
        this.m.put(100L, 100L);
        this.m.put(101L, 101L);
        this.m.put(101L, 101L);
        this.m.put(103L, 103L);
        this.m.put(99L, 99L);
        this.m.put(102L, 102L);
        long n = 102L;
        CopyOnWriteArrayMap tm102 = (CopyOnWriteArrayMap)this.m.tailMap((Object)102L, true);
        for (Map.Entry e : tm102.entrySet()) {
            Assert.assertEquals((Object)n, e.getKey());
            Assert.assertEquals((Object)n, e.getValue());
            ++n;
        }
        n = 99L;
        CopyOnWriteArrayMap tm98 = (CopyOnWriteArrayMap)this.m.tailMap((Object)98L, true);
        for (Map.Entry e : tm98.entrySet()) {
            Assert.assertEquals((Object)n, e.getKey());
            Assert.assertEquals((Object)n, e.getValue());
            ++n;
        }
    }

    @Test
    public void testPut() throws Exception {
        this.m.clear();
        this.m.put(100L, 100L);
        this.m.put(101L, 101L);
        this.m.put(101L, 101L);
        this.m.put(103L, 103L);
        this.m.put(99L, 99L);
        this.m.put(102L, 102L);
        long n = 99L;
        for (Map.Entry e : this.m.entrySet()) {
            Assert.assertEquals((Object)n, e.getKey());
            Assert.assertEquals((Object)n, e.getValue());
            ++n;
        }
        Assert.assertEquals((long)5L, (long)this.m.size());
        Assert.assertFalse((boolean)this.m.isEmpty());
    }
}

