/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestCommonFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestCommonFSUtils.class);
    private HBaseCommonTestingUtility htu;
    private Configuration conf;
    private static final boolean STREAM_CAPABILITIES_IS_PRESENT;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.conf = this.htu.getConfiguration();
    }

    @Test
    public void testMatchingTail() throws IOException {
        Path rootdir = this.htu.getDataTestDir();
        FileSystem fs = rootdir.getFileSystem(this.conf);
        Assert.assertTrue((rootdir.depth() > 1 ? 1 : 0) != 0);
        Path partPath = new Path("a", "b");
        Path fullPath = new Path(rootdir, partPath);
        Path fullyQualifiedPath = fs.makeQualified(fullPath);
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (Path)partPath));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (String)partPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)fullPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)partPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)partPath));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fullPath));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertTrue((boolean)CommonFSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fs.makeQualified(fullPath)));
        Assert.assertTrue((boolean)CommonFSUtils.isStartingWithPath((Path)rootdir, (String)fullyQualifiedPath.toString()));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)fullPath, (Path)new Path("x")));
        Assert.assertFalse((boolean)CommonFSUtils.isMatchingTail((Path)new Path("x"), (Path)fullPath));
    }

    private void WriteDataToHDFS(FileSystem fs, Path file, int dataSize) throws Exception {
        FSDataOutputStream out = fs.create(file);
        byte[] data = new byte[dataSize];
        out.write(data, 0, dataSize);
        out.close();
    }

    @Test
    public void testSetWALRootDir() throws Exception {
        Path p = new Path("file:///hbase/root");
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)p.toString(), (Object)this.conf.get("hbase.wal.dir"));
    }

    @Test
    public void testGetWALRootDir() throws IOException {
        Path root = new Path("file:///hbase/root");
        Path walRoot = new Path("file:///hbase/logroot");
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)root);
        Assert.assertEquals((Object)root, (Object)CommonFSUtils.getRootDir((Configuration)this.conf));
        Assert.assertEquals((Object)root, (Object)CommonFSUtils.getWALRootDir((Configuration)this.conf));
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)walRoot);
        Assert.assertEquals((Object)walRoot, (Object)CommonFSUtils.getWALRootDir((Configuration)this.conf));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetWALRootDirIllegalWALDir() throws IOException {
        Path root = new Path("file:///hbase/root");
        Path invalidWALDir = new Path("file:///hbase/root/logroot");
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)root);
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)invalidWALDir);
        CommonFSUtils.getWALRootDir((Configuration)this.conf);
    }

    @Test
    public void testRemoveWALRootPath() throws Exception {
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)new Path("file:///user/hbase"));
        Path testFile = new Path(CommonFSUtils.getRootDir((Configuration)this.conf), "test/testfile");
        Path tmpFile = new Path("file:///test/testfile");
        Assert.assertEquals((Object)"test/testfile", (Object)CommonFSUtils.removeWALRootPath((Path)testFile, (Configuration)this.conf));
        Assert.assertEquals((Object)tmpFile.toString(), (Object)CommonFSUtils.removeWALRootPath((Path)tmpFile, (Configuration)this.conf));
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)new Path("file:///user/hbaseLogDir"));
        Assert.assertEquals((Object)testFile.toString(), (Object)CommonFSUtils.removeWALRootPath((Path)testFile, (Configuration)this.conf));
        Path logFile = new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "test/testlog");
        Assert.assertEquals((Object)"test/testlog", (Object)CommonFSUtils.removeWALRootPath((Path)logFile, (Configuration)this.conf));
    }

    @Test(expected=NullPointerException.class)
    public void streamCapabilitiesDoesNotAllowNullStream() {
        CommonFSUtils.hasCapability(null, (String)"hopefully any string");
    }

    @Test
    public void checkStreamCapabilitiesOnKnownNoopStream() throws IOException {
        FSDataOutputStream stream = new FSDataOutputStream((OutputStream)new ByteArrayOutputStream(), null);
        Assert.assertNotEquals((String)"We expect our dummy FSDOS to claim capabilities iff the StreamCapabilities class is not defined.", (Object)STREAM_CAPABILITIES_IS_PRESENT, (Object)CommonFSUtils.hasCapability((FSDataOutputStream)stream, (String)"hsync"));
        Assert.assertNotEquals((String)"We expect our dummy FSDOS to claim capabilities iff the StreamCapabilities class is not defined.", (Object)STREAM_CAPABILITIES_IS_PRESENT, (Object)CommonFSUtils.hasCapability((FSDataOutputStream)stream, (String)"hflush"));
        Assert.assertNotEquals((String)"We expect our dummy FSDOS to claim capabilities iff the StreamCapabilities class is not defined.", (Object)STREAM_CAPABILITIES_IS_PRESENT, (Object)CommonFSUtils.hasCapability((FSDataOutputStream)stream, (String)"a capability that hopefully no filesystem will implement."));
    }

    static {
        boolean tmp = false;
        try {
            Class.forName("org.apache.hadoop.fs.StreamCapabilities");
            tmp = true;
            LOG.debug("Test thought StreamCapabilities class was present.");
        }
        catch (ClassNotFoundException exception) {
            LOG.debug("Test didn't think StreamCapabilities class was present.");
        }
        finally {
            STREAM_CAPABILITIES_IS_PRESENT = tmp;
        }
    }
}

