/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestConcatenatedLists {
    @Test
    public void testUnsupportedOps() {
        ConcatenatedLists c = new ConcatenatedLists();
        c.addSublist(Arrays.asList(0L, 1L));
        try {
            c.add((Object)2L);
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            c.addAll(Arrays.asList(2L, 3L));
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            c.remove((Object)0L);
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            c.removeAll(Arrays.asList(0L, 1L));
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            c.clear();
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            c.retainAll(Arrays.asList(0L, 2L));
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator iter = c.iterator();
        iter.next();
        try {
            iter.remove();
            Assert.fail((String)"Should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testEmpty() {
        this.verify((ConcatenatedLists<Long>)new ConcatenatedLists(), -1);
    }

    @Test
    public void testOneOne() {
        ConcatenatedLists c = new ConcatenatedLists();
        c.addSublist(Arrays.asList(0L));
        this.verify((ConcatenatedLists<Long>)c, 0);
    }

    @Test
    public void testOneMany() {
        ConcatenatedLists c = new ConcatenatedLists();
        c.addSublist(Arrays.asList(0L, 1L, 2L));
        this.verify((ConcatenatedLists<Long>)c, 2);
    }

    @Test
    public void testManyOne() {
        ConcatenatedLists c = new ConcatenatedLists();
        c.addSublist(Arrays.asList(0L));
        c.addAllSublists(Arrays.asList(Arrays.asList(1L), Arrays.asList(2L)));
        this.verify((ConcatenatedLists<Long>)c, 2);
    }

    @Test
    public void testManyMany() {
        ConcatenatedLists c = new ConcatenatedLists();
        c.addAllSublists(Arrays.asList(Arrays.asList(0L, 1L)));
        c.addSublist(Arrays.asList(2L, 3L, 4L));
        c.addAllSublists(Arrays.asList(Arrays.asList(5L), Arrays.asList(6L, 7L)));
        this.verify((ConcatenatedLists<Long>)c, 7);
    }

    @SuppressWarnings(value={"DMI_VACUOUS_SELF_COLLECTION_CALL"}, justification="Intended vacuous containsAll call on 'c'")
    private void verify(ConcatenatedLists<Long> c, int last) {
        Assert.assertEquals((Object)(last == -1 ? 1 : 0), (Object)c.isEmpty());
        Assert.assertEquals((long)(last + 1), (long)c.size());
        Assert.assertTrue((boolean)c.containsAll(c));
        Long[] array = (Long[])c.toArray((Object[])new Long[c.size()]);
        ArrayList<Long> all = new ArrayList<Long>();
        Iterator iter = c.iterator();
        Long i = 0L;
        while (i <= (long)last) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)i, iter.next());
            Assert.assertEquals((Object)i, (Object)array[i.intValue()]);
            Assert.assertTrue((boolean)c.contains((Object)i));
            Assert.assertTrue((boolean)c.containsAll(Arrays.asList(i)));
            all.add(i);
            i = i + 1L;
        }
        Assert.assertTrue((boolean)c.containsAll(all));
        Assert.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            Assert.fail((String)"Should have thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

