/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBufferListOutputStream;
import org.apache.hadoop.hbase.io.ByteBufferPool;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestByteBufferListOutputStream {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferListOutputStream.class);

    @Test
    public void testWrites() throws Exception {
        ByteBufferPool pool = new ByteBufferPool(10, 3);
        ByteBufferListOutputStream bbos = new ByteBufferListOutputStream(pool);
        bbos.write(2);
        bbos.writeInt(100);
        byte[] b = Bytes.toBytes((String)"row123");
        bbos.write(b);
        ByteBuffer bb1 = pool.getBuffer();
        ByteBuffer bb = ByteBuffer.wrap(Bytes.toBytes((String)"row123_cf1_q1"));
        bbos.write(bb, 0, bb.capacity());
        pool.putbackBuffer(bb1);
        bbos.writeInt(123);
        bbos.writeInt(124);
        Assert.assertEquals((long)0L, (long)pool.getQueueSize());
        List allBufs = bbos.getByteBuffers();
        Assert.assertEquals((long)4L, (long)allBufs.size());
        Assert.assertEquals((long)3L, (long)bbos.bufsFromPool.size());
        ByteBuffer b1 = (ByteBuffer)allBufs.get(0);
        Assert.assertEquals((long)10L, (long)b1.remaining());
        Assert.assertEquals((long)2L, (long)b1.get());
        Assert.assertEquals((long)100L, (long)b1.getInt());
        byte[] bActual = new byte[b.length];
        b1.get(bActual, 0, 5);
        ByteBuffer b2 = (ByteBuffer)allBufs.get(1);
        Assert.assertEquals((long)10L, (long)b2.remaining());
        b2.get(bActual, 5, 1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])b, (byte[])bActual));
        bActual = new byte[bb.capacity()];
        b2.get(bActual, 0, 9);
        ByteBuffer b3 = (ByteBuffer)allBufs.get(2);
        Assert.assertEquals((long)8L, (long)b3.remaining());
        b3.get(bActual, 9, 4);
        Assert.assertTrue((boolean)ByteBufferUtils.equals((ByteBuffer)bb, (int)0, (int)bb.capacity(), (byte[])bActual, (int)0, (int)bActual.length));
        Assert.assertEquals((long)123L, (long)b3.getInt());
        ByteBuffer b4 = (ByteBuffer)allBufs.get(3);
        Assert.assertEquals((long)4L, (long)b4.remaining());
        Assert.assertEquals((long)124L, (long)b4.getInt());
        bbos.releaseResources();
        Assert.assertEquals((long)3L, (long)pool.getQueueSize());
    }
}

