/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagBuilder;
import org.apache.hadoop.hbase.TagBuilderFactory;
import org.apache.hadoop.hbase.TagBuilderImpl;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTagBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTagBuilder.class);

    @Test
    public void testArrayBackedTagBuilder() {
        byte type = 50;
        String value = "Array-Backed-Tag";
        TagBuilder builder = TagBuilderFactory.create();
        Assert.assertTrue((boolean)(builder instanceof TagBuilderImpl));
        builder.setTagType(type);
        builder.setTagValue(Bytes.toBytes((String)value));
        Tag tag = builder.build();
        Assert.assertEquals((Object)value, (Object)Tag.getValueAsString((Tag)tag));
        Assert.assertEquals((long)type, (long)tag.getType());
    }

    @Test
    public void testErrorMessages() {
        String arrayValue = "Array-Backed-Tag";
        TagBuilder builder = TagBuilderFactory.create();
        builder.setTagValue(Bytes.toBytes((String)arrayValue));
        try {
            builder.build();
            Assert.fail((String)"Shouldn't have come here.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("Need to set type of the tag."));
        }
        byte type = 50;
        builder = TagBuilderFactory.create();
        builder.setTagType(type);
        try {
            builder.build();
            Assert.fail((String)"Shouldn't have come here.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("TagBytes can't be null"));
        }
    }
}

