/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestBytes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBytes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUnsafe(boolean value) throws Exception {
        Field field = Bytes.class.getDeclaredField("UNSAFE_UNALIGNED");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        int oldModifiers = field.getModifiers();
        modifiersField.setInt(field, oldModifiers & 0xFFFFFFEF);
        try {
            field.set(null, value);
        }
        finally {
            modifiersField.setInt(field, oldModifiers);
        }
        Assert.assertEquals((Object)Bytes.UNSAFE_UNALIGNED, (Object)value);
    }

    @Test
    public void testShort() throws Exception {
        TestBytes.testShort(false);
    }

    @Test
    public void testShortUnsafe() throws Exception {
        TestBytes.testShort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testShort(boolean unsafe) throws Exception {
        TestBytes.setUnsafe(unsafe);
        try {
            for (short n : Arrays.asList((short)Short.MIN_VALUE, (short)-100, (short)-1, (short)0, (short)1, (short)300, (short)Short.MAX_VALUE)) {
                byte[] bytes = Bytes.toBytes((short)n);
                Assert.assertEquals((long)Bytes.toShort((byte[])bytes, (int)0, (int)bytes.length), (long)n);
            }
        }
        finally {
            TestBytes.setUnsafe(HBasePlatformDependent.unaligned());
        }
    }

    @Test
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        Assert.assertNotNull((Object)ee);
    }

    @Test
    public void testAdd() {
        byte[] a = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] b = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] c = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        byte[] result1 = Bytes.add((byte[])a, (byte[])b, (byte[])c);
        byte[] result2 = Bytes.add((byte[][])new byte[][]{a, b, c});
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])result1, (byte[])result2));
    }

    @Test
    public void testSplit() {
        byte[][] parts;
        byte[] lowest = Bytes.toBytes((String)"AAA");
        byte[] middle = Bytes.toBytes((String)"CCC");
        byte[] highest = Bytes.toBytes((String)"EEE");
        for (byte[] bytes : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1)) {
            System.out.println(Bytes.toString((byte[])bytes));
        }
        Assert.assertEquals((long)3L, (long)parts.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
        highest = Bytes.toBytes((String)"DDD");
        for (byte[] part : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)2)) {
            System.out.println(Bytes.toString((byte[])part));
        }
        Assert.assertEquals((long)4L, (long)parts.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])parts[2], (byte[])middle));
    }

    @Test
    public void testSplit2() {
        byte[][] parts;
        byte[] lowest = Bytes.toBytes((String)"http://A");
        byte[] highest = Bytes.toBytes((String)"http://z");
        byte[] middle = Bytes.toBytes((String)"http://]");
        for (byte[] part : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1)) {
            System.out.println(Bytes.toString((byte[])part));
        }
        Assert.assertEquals((long)3L, (long)parts.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
    }

    @Test
    public void testSplit3() {
        byte[] low = new byte[]{1, 1, 1};
        byte[] high = new byte[]{1, 1, 3};
        try {
            Bytes.split((byte[])high, (byte[])low, (int)1);
            Assert.fail((String)"Should not be able to split if low > high");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[][] parts = Bytes.split((byte[])low, (byte[])high, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println("" + i + " -> " + Bytes.toStringBinary((byte[])parts[i]));
        }
        Assert.assertEquals((String)("Returned split should have 3 parts but has " + parts.length), (long)3L, (long)parts.length);
        parts = Bytes.split((byte[])low, (byte[])high, (int)2);
        Assert.assertNotNull((String)"Split with an additional byte", (Object)parts);
        Assert.assertEquals((long)parts.length, (long)(low.length + 1));
        try {
            Bytes.split((byte[])low, (byte[])high, (int)0);
            Assert.fail((String)"Should not be able to split 0 times");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToInt() {
        int[] ints;
        for (int anInt : ints = new int[]{-1, 123, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((int)anInt);
            Assert.assertEquals((long)anInt, (long)Bytes.toInt((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assert.assertEquals((long)anInt, (long)Bytes.toInt((byte[])b2, (int)1));
            Assert.assertEquals((long)anInt, (long)Bytes.toInt((byte[])b2, (int)1, (int)4));
        }
    }

    @Test
    public void testToLong() {
        long[] longs;
        for (long aLong : longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((long)aLong);
            Assert.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assert.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b2, (int)1));
            Assert.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b2, (int)1, (int)8));
        }
    }

    @Test
    public void testToFloat() {
        float[] floats;
        for (float aFloat : floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((float)aFloat);
            Assert.assertEquals((float)aFloat, (float)Bytes.toFloat((byte[])b), (float)0.0f);
            byte[] b2 = this.bytesWithOffset(b);
            Assert.assertEquals((float)aFloat, (float)Bytes.toFloat((byte[])b2, (int)1), (float)0.0f);
        }
    }

    @Test
    public void testToDouble() {
        double[] doubles;
        for (double aDouble : doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((double)aDouble);
            Assert.assertEquals((double)aDouble, (double)Bytes.toDouble((byte[])b), (double)0.0);
            byte[] b2 = this.bytesWithOffset(b);
            Assert.assertEquals((double)aDouble, (double)Bytes.toDouble((byte[])b2, (int)1), (double)0.0);
        }
    }

    @Test
    public void testToBigDecimal() {
        BigDecimal[] decimals;
        for (BigDecimal decimal : decimals = new BigDecimal[]{new BigDecimal("-1"), new BigDecimal("123.123"), new BigDecimal("123123123123")}) {
            byte[] b = Bytes.toBytes((BigDecimal)decimal);
            Assert.assertEquals((Object)decimal, (Object)Bytes.toBigDecimal((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assert.assertEquals((Object)decimal, (Object)Bytes.toBigDecimal((byte[])b2, (int)1, (int)b.length));
        }
    }

    private byte[] bytesWithOffset(byte[] src) {
        byte[] result = new byte[src.length + 1];
        result[0] = -86;
        System.arraycopy(src, 0, result, 1, src.length);
        return result;
    }

    @Test
    public void testToBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.toBytes((ByteBuffer)target);
        byte[] expected = new byte[]{0, 1, 2, 3, 4, 5, 6};
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Assert.assertEquals((long)2L, (long)target.position());
        Assert.assertEquals((long)7L, (long)target.limit());
        ByteBuffer target2 = target.slice();
        Assert.assertEquals((long)0L, (long)target2.position());
        Assert.assertEquals((long)5L, (long)target2.limit());
        byte[] actual2 = Bytes.toBytes((ByteBuffer)target2);
        byte[] expected2 = new byte[]{2, 3, 4, 5, 6};
        Assert.assertArrayEquals((byte[])expected2, (byte[])actual2);
        Assert.assertEquals((long)0L, (long)target2.position());
        Assert.assertEquals((long)5L, (long)target2.limit());
    }

    @Test
    public void testGetBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.getBytes((ByteBuffer)target);
        byte[] expected = new byte[]{2, 3, 4, 5, 6};
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Assert.assertEquals((long)2L, (long)target.position());
        Assert.assertEquals((long)7L, (long)target.limit());
    }

    @Test
    public void testReadAsVLong() throws Exception {
        long[] longs;
        for (long aLong : longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE}) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(baos);
            WritableUtils.writeVLong((DataOutput)output, (long)aLong);
            byte[] long_bytes_no_offset = baos.toByteArray();
            Assert.assertEquals((long)aLong, (long)Bytes.readAsVLong((byte[])long_bytes_no_offset, (int)0));
            byte[] long_bytes_with_offset = this.bytesWithOffset(long_bytes_no_offset);
            Assert.assertEquals((long)aLong, (long)Bytes.readAsVLong((byte[])long_bytes_with_offset, (int)1));
        }
    }

    @Test
    public void testToStringBinaryForBytes() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        String actual = Bytes.toStringBinary((byte[])array);
        String expected = "09azAZ@\\x01";
        Assert.assertEquals((Object)expected, (Object)actual);
        String actual2 = Bytes.toStringBinary((byte[])array, (int)2, (int)3);
        String expected2 = "azA";
        Assert.assertEquals((Object)expected2, (Object)actual2);
    }

    @Test
    public void testToStringBinaryForArrayBasedByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array);
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringBinaryForReadOnlyByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array).asReadOnlyBuffer();
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBinarySearch() {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        byte[] key4 = new byte[]{0};
        byte[] key5 = new byte[]{2};
        Assert.assertEquals((long)1L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)0, (int)1));
        Assert.assertEquals((long)0L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)1, (int)1));
        Assert.assertEquals((long)-3L, (long)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        Assert.assertEquals((long)-3L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)0, (int)1));
        Assert.assertEquals((long)4L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)1, (int)1));
        Assert.assertEquals((long)2L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)0, (int)1));
        Assert.assertEquals((long)5L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)1, (int)1));
        Assert.assertEquals((long)-1L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key4, (int)0, (int)1));
        Assert.assertEquals((long)-2L, (long)Bytes.binarySearch((byte[][])arr, (byte[])key5, (int)0, (int)1));
        for (int i = 0; i < arr.length; ++i) {
            Assert.assertEquals((long)(-(i + 1)), (long)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] - 1)}, (int)0, (int)1));
            Assert.assertEquals((long)(-(i + 2)), (long)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] + 1)}, (int)0, (int)1));
        }
    }

    @Test
    public void testToStringBytesBinaryReversible() {
        byte[] randomBytes = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            Bytes.random((byte[])randomBytes);
            this.verifyReversibleForBytes(randomBytes);
        }
        this.verifyReversibleForBytes(new byte[0]);
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68});
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68, 92});
    }

    private void verifyReversibleForBytes(byte[] originalBytes) {
        String convertedString = Bytes.toStringBinary((byte[])originalBytes);
        byte[] convertedBytes = Bytes.toBytesBinary((String)convertedString);
        if (Bytes.compareTo((byte[])originalBytes, (byte[])convertedBytes) != 0) {
            Assert.fail((String)("Not reversible for\nbyte[]: " + Arrays.toString(originalBytes) + ",\nStringBinary: " + convertedString));
        }
    }

    @Test
    public void testStartsWith() {
        Assert.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"h")));
        Assert.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"")));
        Assert.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"hello")));
        Assert.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"helloworld")));
        Assert.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)""), (byte[])Bytes.toBytes((String)"hello")));
    }

    @Test
    public void testIncrementBytes() {
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, 1L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(12L, 123435445L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(124634654L, 1L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10005460L, 5005645L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1L, -1L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -1L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -5L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1005435000L, -5L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -43657655L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1L, 1L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-26L, 5034520L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10657200L, 5L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, 45376475L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10L, -5L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, -5L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12L, -34565445L));
        Assert.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) {
        byte[] value = Bytes.toBytes((long)val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong((byte[])Bytes.incrementBytes((byte[])value, (long)amount));
        return Bytes.toLong((byte[])testValue) + amount == incrementResult;
    }

    @Test
    public void testFixedSizeString() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"Hello", (int)5);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"World", (int)18);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"", (int)9);
        try {
            Bytes.writeStringFixedSize((DataOutput)dos, (String)"Too\u2013Long", (int)9);
            Assert.fail((String)"Exception expected");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)"Trying to write 10 bytes (Too\\xE2\\x80\\x93Long) into a field of length 9", (Object)ex.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        Assert.assertEquals((Object)"Hello", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)5));
        Assert.assertEquals((Object)"World", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)18));
        Assert.assertEquals((Object)"", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)9));
    }

    @Test
    public void testCopy() {
        byte[] bytes = Bytes.toBytes((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        byte[] copy = Bytes.copy((byte[])bytes);
        Assert.assertNotSame((Object)bytes, (Object)copy);
        Assert.assertTrue((boolean)Bytes.equals((byte[])bytes, (byte[])copy));
    }

    @Test
    public void testToBytesBinaryTrailingBackslashes() {
        try {
            Bytes.toBytesBinary((String)"abc\\x00\\x01\\");
        }
        catch (StringIndexOutOfBoundsException ex) {
            Assert.fail((String)("Illegal string access: " + ex.getMessage()));
        }
    }

    @Test
    public void testToStringBinary_toBytesBinary_Reversable() {
        String bytes = Bytes.toStringBinary((byte[])Bytes.toBytes((double)2.17));
        Assert.assertEquals((double)2.17, (double)Bytes.toDouble((byte[])Bytes.toBytesBinary((String)bytes)), (double)0.0);
    }

    @Test
    public void testUnsignedBinarySearch() {
        byte[] bytes = new byte[]{0, 5, 123, 127, -128, -100, -1};
        Assert.assertEquals((long)1L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)5));
        Assert.assertEquals((long)3L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)127));
        Assert.assertEquals((long)4L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-128));
        Assert.assertEquals((long)5L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-100));
        Assert.assertEquals((long)6L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-1));
        Assert.assertEquals((long)-2L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)2));
        Assert.assertEquals((long)-7L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-5));
    }

    @Test
    public void testUnsignedIncrement() {
        byte[] a = Bytes.toBytes((int)0);
        int a2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])a), (int)0);
        Assert.assertEquals((long)1L, (long)a2);
        byte[] b = Bytes.toBytes((int)-1);
        byte[] actual = Bytes.unsignedCopyAndIncrement((byte[])b);
        Assert.assertNotSame((Object)b, (Object)actual);
        byte[] expected = new byte[]{1, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        byte[] c = Bytes.toBytes((int)255);
        int c2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])c), (int)0);
        Assert.assertEquals((long)256L, (long)c2);
    }

    @Test
    public void testIndexOf() {
        byte[] array = Bytes.toBytes((String)"hello");
        Assert.assertEquals((long)1L, (long)Bytes.indexOf((byte[])array, (byte)101));
        Assert.assertEquals((long)4L, (long)Bytes.indexOf((byte[])array, (byte)111));
        Assert.assertEquals((long)-1L, (long)Bytes.indexOf((byte[])array, (byte)97));
        Assert.assertEquals((long)0L, (long)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hel")));
        Assert.assertEquals((long)2L, (long)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"ll")));
        Assert.assertEquals((long)-1L, (long)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hll")));
    }

    @Test
    public void testContains() {
        byte[] array = Bytes.toBytes((String)"hello world");
        Assert.assertTrue((boolean)Bytes.contains((byte[])array, (byte)101));
        Assert.assertTrue((boolean)Bytes.contains((byte[])array, (byte)100));
        Assert.assertFalse((boolean)Bytes.contains((byte[])array, (byte)97));
        Assert.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"world")));
        Assert.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"ello")));
        Assert.assertFalse((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"owo")));
    }

    @Test
    public void testZero() {
        int i;
        byte[] array = Bytes.toBytes((String)"hello");
        Bytes.zero((byte[])array);
        for (byte b : array) {
            Assert.assertEquals((long)0L, (long)b);
        }
        array = Bytes.toBytes((String)"hello world");
        Bytes.zero((byte[])array, (int)2, (int)7);
        Assert.assertFalse((array[0] == 0 ? 1 : 0) != 0);
        Assert.assertFalse((array[1] == 0 ? 1 : 0) != 0);
        for (i = 2; i < 9; ++i) {
            Assert.assertEquals((long)0L, (long)array[i]);
        }
        for (i = 9; i < array.length; ++i) {
            Assert.assertFalse((array[i] == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPutBuffer() {
        byte i;
        byte[] b = new byte[100];
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Bytes.putByteBuffer((byte[])b, (int)i, (ByteBuffer)ByteBuffer.wrap(new byte[]{i}));
        }
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)b[i]);
        }
    }

    @Test
    public void testToFromHex() {
        ArrayList<String> testStrings = new ArrayList<String>(8);
        testStrings.addAll(Arrays.asList("", "00", "A0", "ff", "FFffFFFFFFFFFF", "12", "0123456789abcdef", "283462839463924623984692834692346ABCDFEDDCA0"));
        for (String testString : testStrings) {
            byte[] byteData = Bytes.fromHex((String)testString);
            Assert.assertEquals((long)(testString.length() / 2), (long)byteData.length);
            String string = Bytes.toHex((byte[])byteData);
            Assert.assertTrue((boolean)testString.equalsIgnoreCase(string));
        }
        ArrayList<Object> testByteData = new ArrayList<Object>(5);
        testByteData.addAll(Arrays.asList(new byte[0], new byte[1], new byte[10], {1, 2, 3, 4, 5}, {-1}));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 20; ++i) {
            byte[] byArray = new byte[((Random)rand).nextInt(100)];
            Bytes.random((byte[])byArray);
            testByteData.add(byArray);
        }
        for (byte[] byArray : testByteData) {
            String hexString = Bytes.toHex((byte[])byArray);
            Assert.assertEquals((long)(byArray.length * 2), (long)hexString.length());
            byte[] result = Bytes.fromHex((String)hexString);
            Assert.assertArrayEquals((byte[])byArray, (byte[])result);
        }
    }
}

