/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.IndividualBytesFieldCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestIndividualBytesFieldCell {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIndividualBytesFieldCell.class);
    private static IndividualBytesFieldCell ic0 = null;
    private static KeyValue kv0 = null;

    @BeforeClass
    public static void testConstructorAndVerify() {
        byte[] row = Bytes.toBytes((String)"immutable-row");
        byte[] family = Bytes.toBytes((String)"immutable-family");
        byte[] qualifier = Bytes.toBytes((String)"immutable-qualifier");
        byte[] value = Bytes.toBytes((String)"immutable-value");
        byte[] tags = Bytes.toBytes((String)"immutable-tags");
        long timestamp = 5000L;
        long seqId = 0L;
        KeyValue.Type type = KeyValue.Type.Put;
        ic0 = new IndividualBytesFieldCell(row, family, qualifier, timestamp, type, seqId, value, tags);
        kv0 = new KeyValue(row, family, qualifier, timestamp, type, value, tags);
        Assert.assertTrue((ic0.getRowArray() == row ? 1 : 0) != 0);
        Assert.assertTrue((ic0.getFamilyArray() == family ? 1 : 0) != 0);
        Assert.assertTrue((ic0.getQualifierArray() == qualifier ? 1 : 0) != 0);
        Assert.assertTrue((ic0.getValueArray() == value ? 1 : 0) != 0);
        Assert.assertTrue((ic0.getTagsArray() == tags ? 1 : 0) != 0);
        Assert.assertEquals((long)timestamp, (long)ic0.getTimestamp());
        Assert.assertEquals((long)seqId, (long)ic0.getSequenceId());
        Assert.assertEquals((long)type.getCode(), (long)ic0.getTypeByte());
        Assert.assertEquals((long)0L, (long)ic0.getRowOffset());
        Assert.assertEquals((long)0L, (long)ic0.getFamilyOffset());
        Assert.assertEquals((long)0L, (long)ic0.getQualifierOffset());
        Assert.assertEquals((long)0L, (long)ic0.getValueOffset());
        Assert.assertEquals((long)0L, (long)ic0.getTagsOffset());
    }

    @Test
    public void testClone() throws CloneNotSupportedException {
        IndividualBytesFieldCell cloned = (IndividualBytesFieldCell)ic0.clone();
        Assert.assertTrue((cloned.getRowArray() == ic0.getRowArray() ? 1 : 0) != 0);
        Assert.assertTrue((cloned.getFamilyArray() == ic0.getFamilyArray() ? 1 : 0) != 0);
        Assert.assertTrue((cloned.getQualifierArray() == ic0.getQualifierArray() ? 1 : 0) != 0);
        Assert.assertTrue((cloned.getValueArray() == ic0.getValueArray() ? 1 : 0) != 0);
        Assert.assertTrue((cloned.getTagsArray() == ic0.getTagsArray() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(ic0.deepClone() instanceof KeyValue));
    }

    @Test
    public void testWriteIntoKeyValueFormat() throws IOException {
        Assert.assertEquals((long)kv0.getSerializedSize(true), (long)ic0.getSerializedSize(true));
        Assert.assertEquals((long)kv0.getSerializedSize(false), (long)ic0.getSerializedSize(false));
        ByteBuffer bbufIC = ByteBuffer.allocate(ic0.getSerializedSize(true));
        ic0.write(bbufIC, 0);
        ByteBuffer bbufKV = ByteBuffer.allocate(kv0.getSerializedSize(true));
        kv0.write(bbufKV, 0);
        Assert.assertTrue((boolean)bbufIC.equals(bbufKV));
        this.testWriteIntoOutputStream(ic0, kv0, true);
        this.testWriteIntoOutputStream(ic0, kv0, false);
    }

    private void testWriteIntoOutputStream(IndividualBytesFieldCell ic, KeyValue kv, boolean withTags) throws IOException {
        ByteArrayOutputStream outIC = new ByteArrayOutputStream(ic.getSerializedSize(withTags));
        ByteArrayOutputStream outKV = new ByteArrayOutputStream(kv.getSerializedSize(withTags));
        Assert.assertEquals((long)kv.write((OutputStream)outKV, withTags), (long)ic.write((OutputStream)outIC, withTags));
        Assert.assertArrayEquals((byte[])outKV.getBuffer(), (byte[])outIC.getBuffer());
    }

    @Test
    public void testNullFamilyQualifierValueTags() {
        byte[] row = Bytes.toBytes((String)"row1");
        long timestamp = 5000L;
        long seqId = 0L;
        KeyValue.Type type = KeyValue.Type.Put;
        byte[] family = null;
        byte[] qualifier = null;
        byte[] value = null;
        byte[] tags = null;
        IndividualBytesFieldCell ic1 = new IndividualBytesFieldCell(row, family, qualifier, timestamp, type, seqId, value, tags);
        KeyValue kv1 = new KeyValue(row, family, qualifier, timestamp, type, value, tags);
        byte[] familyArrayInKV = Bytes.copy((byte[])kv1.getFamilyArray(), (int)kv1.getFamilyOffset(), (int)kv1.getFamilyLength());
        byte[] qualifierArrayInKV = Bytes.copy((byte[])kv1.getQualifierArray(), (int)kv1.getQualifierOffset(), (int)kv1.getQualifierLength());
        byte[] valueArrayInKV = Bytes.copy((byte[])kv1.getValueArray(), (int)kv1.getValueOffset(), (int)kv1.getValueLength());
        byte[] tagsArrayInKV = Bytes.copy((byte[])kv1.getTagsArray(), (int)kv1.getTagsOffset(), (int)kv1.getTagsLength());
        Assert.assertArrayEquals((byte[])familyArrayInKV, (byte[])ic1.getFamilyArray());
        Assert.assertArrayEquals((byte[])qualifierArrayInKV, (byte[])ic1.getQualifierArray());
        Assert.assertArrayEquals((byte[])valueArrayInKV, (byte[])ic1.getValueArray());
        Assert.assertArrayEquals((byte[])tagsArrayInKV, (byte[])ic1.getTagsArray());
        Assert.assertEquals((long)kv1.getFamilyLength(), (long)ic1.getFamilyLength());
        Assert.assertEquals((long)kv1.getQualifierLength(), (long)ic1.getQualifierLength());
        Assert.assertEquals((long)kv1.getValueLength(), (long)ic1.getValueLength());
        Assert.assertEquals((long)kv1.getTagsLength(), (long)ic1.getTagsLength());
    }

    @Test
    public void testIfExtendedCellImplemented() {
        IndividualBytesFieldCell ec = ic0;
        ec.deepClone();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalRow() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 100, HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0, 0L, KeyValue.Type.Put, 0L, HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalFamily() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 100, HConstants.EMPTY_BYTE_ARRAY, 0, 0, 0L, KeyValue.Type.Put, 0L, HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalQualifier() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 100, 0L, KeyValue.Type.Put, 0L, HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalTimestamp() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 9, -100L, KeyValue.Type.Put, 0L, HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalValue() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 9, 0L, KeyValue.Type.Put, 0L, Bytes.toBytes((String)"value"), 0, 100, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalTags() {
        new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 9, 0L, KeyValue.Type.Put, 0L, Bytes.toBytes((String)"value"), 0, 5, Bytes.toBytes((String)"tags"), 0, 100);
    }

    @Test
    public void testWriteTag() throws IOException {
        byte[] tags = Bytes.toBytes((String)"---tags---");
        int tagOffset = 3;
        int length = 4;
        IndividualBytesFieldCell cell = new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 9, 0L, KeyValue.Type.Put, 0L, Bytes.toBytes((String)"value"), 0, 5, tags, tagOffset, length);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(300);){
            cell.write((OutputStream)output, true);
            byte[] buf = output.toByteArray();
            Assert.assertEquals((long)cell.getSerializedSize(true), (long)buf.length);
        }
    }

    @Test
    public void testWriteValue() throws IOException {
        byte[] value = Bytes.toBytes((String)"---value---");
        int valueOffset = 3;
        int valueLength = 5;
        IndividualBytesFieldCell cell = new IndividualBytesFieldCell(Bytes.toBytes((String)"row"), 0, 3, Bytes.toBytes((String)"family"), 0, 6, Bytes.toBytes((String)"qualifier"), 0, 9, 0L, KeyValue.Type.Put, 0L, value, valueOffset, valueLength, Bytes.toBytes((String)"value"), 0, 5);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(300);){
            cell.write((OutputStream)output, true);
            byte[] buf = output.toByteArray();
            Assert.assertEquals((long)cell.getSerializedSize(true), (long)buf.length);
        }
    }
}

