/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.FileChangeWatcher;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestFileChangeWatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileChangeWatcher.class);
    private static File tempDir;
    private static File tempFile;
    private static final Logger LOG;
    private static final HBaseCommonTestingUtility UTIL;
    private static final long FS_TIMEOUT = 30000L;

    @BeforeClass
    public static void createTempFile() throws IOException {
        tempDir = new File(UTIL.getDataTestDir(TestFileChangeWatcher.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)tempDir);
        tempFile = File.createTempFile("zk_test_", "", tempDir);
    }

    @AfterClass
    public static void cleanupTempDir() {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testEnableCertFileReloading() throws IOException {
        Configuration myConf = new Configuration();
        String sharedPath = "/tmp/foo.jks";
        myConf.set("hbase.rpc.tls.keystore.location", sharedPath);
        myConf.set("hbase.rpc.tls.truststore.location", sharedPath);
        AtomicReference keystoreWatcher = new AtomicReference();
        AtomicReference truststoreWatcher = new AtomicReference();
        X509Util.enableCertFileReloading((Configuration)myConf, keystoreWatcher, truststoreWatcher, () -> {});
        Assert.assertNotNull(keystoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)keystoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"-foo.jks"));
        Assert.assertNull(truststoreWatcher.get());
        ((FileChangeWatcher)keystoreWatcher.getAndSet(null)).stop();
        truststoreWatcher.set(null);
        String truststorePath = "/tmp/bar.jks";
        myConf.set("hbase.rpc.tls.truststore.location", truststorePath);
        X509Util.enableCertFileReloading((Configuration)myConf, keystoreWatcher, truststoreWatcher, () -> {});
        Assert.assertNotNull(keystoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)keystoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"-foo.jks"));
        Assert.assertNotNull(truststoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)truststoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"-bar.jks"));
        ((FileChangeWatcher)keystoreWatcher.getAndSet(null)).stop();
        ((FileChangeWatcher)truststoreWatcher.getAndSet(null)).stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileChanges() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), "test", event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            for (int i = 0; i < 3; ++i) {
                LOG.info("Modifying file, attempt {}", (Object)(i + 1));
                FileUtils.writeStringToFile((File)tempFile, (String)("Hello world " + i + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                ArrayList arrayList = events;
                synchronized (arrayList) {
                    if (events.size() < i + 1) {
                        events.wait(30000L);
                    }
                    Assert.assertEquals((String)"Wrong number of events", (long)(i + 1), (long)events.size());
                    WatchEvent event2 = (WatchEvent)events.get(i);
                    Assert.assertEquals(StandardWatchEventKinds.ENTRY_MODIFY, event2.kind());
                    Assert.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
                    continue;
                }
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileTouched() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), "test", event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Touching file");
            FileUtils.touch((File)tempFile);
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assert.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assert.assertEquals(StandardWatchEventKinds.ENTRY_MODIFY, event2.kind());
                Assert.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileAdded() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), "test", event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            File tempFile2 = File.createTempFile("zk_test_", "", tempDir);
            tempFile2.deleteOnExit();
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assert.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assert.assertEquals(StandardWatchEventKinds.ENTRY_CREATE, event2.kind());
                Assert.assertEquals((Object)tempFile2.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileDeleted() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), "test", event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            tempFile.delete();
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assert.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assert.assertEquals(StandardWatchEventKinds.ENTRY_DELETE, event2.kind());
                Assert.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackErrorDoesNotCrashWatcherThread() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            AtomicInteger callCount = new AtomicInteger(0);
            watcher = new FileChangeWatcher(tempDir.toPath(), "test", event -> {
                int oldValue;
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                AtomicInteger atomicInteger = callCount;
                synchronized (atomicInteger) {
                    oldValue = callCount.getAndIncrement();
                    callCount.notifyAll();
                }
                if (oldValue == 0) {
                    throw new RuntimeException("This error should not crash the watcher thread");
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Modifying file");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            AtomicInteger atomicInteger = callCount;
            synchronized (atomicInteger) {
                while (callCount.get() == 0) {
                    callCount.wait(30000L);
                }
            }
            LOG.info("Modifying file again");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world again\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            atomicInteger = callCount;
            synchronized (atomicInteger) {
                if (callCount.get() == 1) {
                    callCount.wait(30000L);
                }
            }
            Assert.assertTrue((callCount.get() > 1 ? 1 : 0) != 0);
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TestFileChangeWatcher.class);
        UTIL = new HBaseCommonTestingUtility();
    }
}

