/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Interner;
import org.apache.hbase.thirdparty.com.google.common.collect.Interners;
import org.apache.hbase.thirdparty.com.google.common.net.InetAddresses;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerName
implements Comparable<ServerName>,
Serializable {
    private static final long serialVersionUID = 1367463982557264981L;
    private static final short VERSION = 0;
    static final byte[] VERSION_BYTES = Bytes.toBytes((short)0);
    public static final int NON_STARTCODE = -1;
    public static final String SERVERNAME_SEPARATOR = ",";
    public static final Pattern SERVERNAME_PATTERN = Pattern.compile("[^,]+,[\\d]+,[\\d]+$");
    public static final String UNKNOWN_SERVERNAME = "#unknown#";
    private final String servername;
    private final long startcode;
    private transient Address address;
    private byte[] bytes;
    public static final List<ServerName> EMPTY_SERVER_LIST = new ArrayList<ServerName>(0);
    private static final Interner<ServerName> INTERN_POOL = Interners.newWeakInterner();

    protected ServerName(String hostname, int port, long startcode) {
        this(Address.fromParts(hostname, port), startcode);
    }

    private ServerName(Address address, long startcode) {
        this.address = address;
        this.startcode = startcode;
        this.servername = ServerName.getServerName(this.address.getHostname(), this.address.getPort(), startcode);
    }

    private ServerName(String hostAndPort, long startCode) {
        this(Address.fromString(hostAndPort), startCode);
    }

    private static String getHostNameMinusDomain(String hostname) {
        if (InetAddresses.isInetAddress((String)hostname)) {
            return hostname;
        }
        String[] parts = hostname.split("\\.");
        if (parts.length == 0) {
            return hostname;
        }
        return parts[0];
    }

    public static ServerName valueOf(String hostname, int port, long startcode) {
        return (ServerName)INTERN_POOL.intern((Object)new ServerName(hostname, port, startcode));
    }

    public static ServerName valueOf(String serverName) {
        String hostname = serverName.substring(0, serverName.indexOf(SERVERNAME_SEPARATOR));
        int port = Integer.parseInt(serverName.split(SERVERNAME_SEPARATOR)[1]);
        long statuscode = Long.parseLong(serverName.substring(serverName.lastIndexOf(SERVERNAME_SEPARATOR) + 1));
        return (ServerName)INTERN_POOL.intern((Object)new ServerName(hostname, port, statuscode));
    }

    public static ServerName valueOf(String hostAndPort, long startCode) {
        return (ServerName)INTERN_POOL.intern((Object)new ServerName(hostAndPort, startCode));
    }

    public static ServerName valueOf(Address address, long startcode) {
        return ServerName.valueOf(address.getHostname(), address.getPort(), startcode);
    }

    public String toString() {
        return this.getServerName();
    }

    public String toShortString() {
        return Addressing.createHostAndPortStr(ServerName.getHostNameMinusDomain(this.address.getHostname()), this.address.getPort());
    }

    public synchronized byte[] getVersionedBytes() {
        if (this.bytes == null) {
            this.bytes = Bytes.add(VERSION_BYTES, Bytes.toBytes(this.getServerName()));
        }
        return this.bytes;
    }

    public String getServerName() {
        return this.servername;
    }

    public String getHostname() {
        return this.address.getHostname();
    }

    public String getHostnameLowerCase() {
        return this.address.getHostname().toLowerCase(Locale.ROOT);
    }

    public int getPort() {
        return this.address.getPort();
    }

    public long getStartcode() {
        return this.startcode;
    }

    private static String getServerName(String hostName, int port, long startcode) {
        return hostName.toLowerCase(Locale.ROOT) + SERVERNAME_SEPARATOR + port + SERVERNAME_SEPARATOR + startcode;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public int compareTo(ServerName other) {
        int compare;
        if (other == null) {
            return -1;
        }
        if (this.getHostname() == null) {
            if (other.getHostname() != null) {
                return 1;
            }
        } else {
            if (other.getHostname() == null) {
                return -1;
            }
            compare = this.getHostname().compareToIgnoreCase(other.getHostname());
            if (compare != 0) {
                return compare;
            }
        }
        if ((compare = this.getPort() - other.getPort()) != 0) {
            return compare;
        }
        return Long.compare(this.getStartcode(), other.getStartcode());
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerName)) {
            return false;
        }
        return this.compareTo((ServerName)o) == 0;
    }

    public static boolean isSameAddress(ServerName left, ServerName right) {
        return left.getAddress().equals(right.getAddress());
    }

    public static ServerName parseVersionedServerName(byte[] versionedBytes) {
        short version = Bytes.toShort(versionedBytes);
        if (version == 0) {
            int length = versionedBytes.length - 2;
            return ServerName.valueOf(Bytes.toString(versionedBytes, 2, length));
        }
        return ServerName.valueOf(Bytes.toString(versionedBytes), -1L);
    }

    public static ServerName parseServerName(String str) {
        return SERVERNAME_PATTERN.matcher(str).matches() ? ServerName.valueOf(str) : ServerName.valueOf(str, -1L);
    }

    public static boolean isFullServerName(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return SERVERNAME_PATTERN.matcher(str).matches();
    }
}

