/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedBlob;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedBlob {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedBlob.class);
    private static final byte[][] VALUES = new byte[][]{null, Bytes.toBytes((String)""), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"22"), Bytes.toBytes((String)"333"), Bytes.toBytes((String)"4444"), Bytes.toBytes((String)"55555"), Bytes.toBytes((String)"666666"), Bytes.toBytes((String)"7777777"), Bytes.toBytes((String)"88888888"), Bytes.toBytes((String)"999999999")};

    @Test
    public void testIsSkippableFalse() {
        OrderedBlob type = new OrderedBlob(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isSkippable());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(20);
        for (OrderedBlob type : new OrderedBlob[]{new OrderedBlob(Order.ASCENDING), new OrderedBlob(Order.DESCENDING)}) {
            for (byte[] val : VALUES) {
                buff.setPosition(0);
                type.encode((PositionedByteRange)buff, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + Bytes.toStringBinary((byte[])val)), (long)buff.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodedClassByteArray() {
        OrderedBlob type = new OrderedBlob(Order.ASCENDING);
        Assert.assertEquals(byte[].class, (Object)type.encodedClass());
    }
}

