/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedFloat32;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedFloat32 {
    private static final Float[] VALUES = new Float[]{Float.valueOf(Float.NaN), Float.valueOf(1.0f), Float.valueOf(22.0f), Float.valueOf(333.0f), Float.valueOf(4444.0f), Float.valueOf(55555.0f), Float.valueOf(666666.0f), Float.valueOf(7777777.0f), Float.valueOf(8888888.0f), Float.valueOf(9999999.0f)};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedFloat32.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsNullableIsFalse() {
        OrderedFloat32 type = new OrderedFloat32(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testEncodedClassIsFloat() {
        OrderedFloat32 type = new OrderedFloat32(Order.ASCENDING);
        Assert.assertEquals(Float.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedFloat32 type : new OrderedFloat32[]{new OrderedFloat32(Order.ASCENDING), new OrderedFloat32(Order.DESCENDING)}) {
            for (Float val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodeNoSupportForNull() {
        this.exception.expect(IllegalArgumentException.class);
        OrderedFloat32 type = new OrderedFloat32(Order.ASCENDING);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
    }

    @Test
    public void testEncodedFloatLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedFloat32 type : new OrderedFloat32[]{new OrderedFloat32(Order.ASCENDING), new OrderedFloat32(Order.DESCENDING)}) {
            for (Float val : VALUES) {
                buffer.setPosition(0);
                type.encodeFloat((PositionedByteRange)buffer, val.floatValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

