/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedInt32;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedInt32 {
    private static final Integer[] VALUES = new Integer[]{1, 22, 333, 4444, 55555, 666666, 7777777, 88888888, 999999999};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedInt32.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsNullableIsFalse() {
        OrderedInt32 type = new OrderedInt32(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testEncodedClassIsInteger() {
        OrderedInt32 type = new OrderedInt32(Order.ASCENDING);
        Assert.assertEquals(Integer.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt32 type : new OrderedInt32[]{new OrderedInt32(Order.ASCENDING), new OrderedInt32(Order.DESCENDING)}) {
            for (Integer val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodeNoSupportForNull() {
        this.exception.expect(IllegalArgumentException.class);
        OrderedInt32 type = new OrderedInt32(Order.ASCENDING);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
    }

    @Test
    public void testEncodedFloatLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt32 type : new OrderedInt32[]{new OrderedInt32(Order.ASCENDING), new OrderedInt32(Order.DESCENDING)}) {
            for (Integer val : VALUES) {
                buffer.setPosition(0);
                type.encodeInt((PositionedByteRange)buffer, val.intValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

