/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.io.WritableUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MiscTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestByteBufferUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferUtils.class);
    private static final String UNSAFE_AVAIL_NAME = "UNSAFE_AVAIL";
    private static final String UNSAFE_UNALIGNED_NAME = "UNSAFE_UNALIGNED";
    private byte[] array;
    private static final int MAX_VLONG_LENGTH = 9;
    private static final Collection<Long> testNumbers;

    @AfterClass
    public static void afterClass() throws Exception {
        TestByteBufferUtils.detectAvailabilityOfUnsafe();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseCommonTestingUtil.BOOLEAN_PARAMETERIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUnsafe(String fieldName, boolean value) throws Exception {
        Field field = ByteBufferUtils.class.getDeclaredField(fieldName);
        field.setAccessible(true);
        Field modifiersField = ReflectionUtils.getModifiersField();
        modifiersField.setAccessible(true);
        int oldModifiers = field.getModifiers();
        modifiersField.setInt(field, oldModifiers & 0xFFFFFFEF);
        try {
            field.set(null, value);
        }
        finally {
            modifiersField.setInt(field, oldModifiers);
        }
    }

    static void disableUnsafe() throws Exception {
        if (ByteBufferUtils.UNSAFE_AVAIL) {
            TestByteBufferUtils.setUnsafe(UNSAFE_AVAIL_NAME, false);
        }
        if (ByteBufferUtils.UNSAFE_UNALIGNED) {
            TestByteBufferUtils.setUnsafe(UNSAFE_UNALIGNED_NAME, false);
        }
        Assert.assertFalse((boolean)ByteBufferUtils.UNSAFE_AVAIL);
        Assert.assertFalse((boolean)ByteBufferUtils.UNSAFE_UNALIGNED);
    }

    static void detectAvailabilityOfUnsafe() throws Exception {
        if (ByteBufferUtils.UNSAFE_AVAIL != HBasePlatformDependent.isUnsafeAvailable()) {
            TestByteBufferUtils.setUnsafe(UNSAFE_AVAIL_NAME, HBasePlatformDependent.isUnsafeAvailable());
        }
        if (ByteBufferUtils.UNSAFE_UNALIGNED != HBasePlatformDependent.unaligned()) {
            TestByteBufferUtils.setUnsafe(UNSAFE_UNALIGNED_NAME, HBasePlatformDependent.unaligned());
        }
        Assert.assertEquals((Object)ByteBufferUtils.UNSAFE_AVAIL, (Object)HBasePlatformDependent.isUnsafeAvailable());
        Assert.assertEquals((Object)ByteBufferUtils.UNSAFE_UNALIGNED, (Object)HBasePlatformDependent.unaligned());
    }

    public TestByteBufferUtils(boolean useUnsafeIfPossible) throws Exception {
        if (useUnsafeIfPossible) {
            TestByteBufferUtils.detectAvailabilityOfUnsafe();
        } else {
            TestByteBufferUtils.disableUnsafe();
        }
    }

    @Before
    public void setUp() {
        this.array = new byte[8];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = (byte)(97 + i);
        }
    }

    private static void addNumber(Set<Long> a, long l) {
        if (l != Long.MIN_VALUE) {
            a.add(l - 1L);
        }
        a.add(l);
        if (l != Long.MAX_VALUE) {
            a.add(l + 1L);
        }
        for (long divisor = 3L; divisor <= 10L; ++divisor) {
            for (long delta = -1L; delta <= 1L; ++delta) {
                a.add(l / divisor + delta);
            }
        }
    }

    @Test
    public void testReadWriteVLong() {
        for (long l : testNumbers) {
            ByteBuffer b = ByteBuffer.allocate(9);
            ByteBufferUtils.writeVLong((ByteBuffer)b, (long)l);
            b.flip();
            Assert.assertEquals((long)l, (long)ByteBufferUtils.readVLong((ByteBuffer)b));
        }
    }

    @Test
    public void testConsistencyWithHadoopVLong() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (long l : testNumbers) {
            baos.reset();
            ByteBuffer b = ByteBuffer.allocate(9);
            ByteBufferUtils.writeVLong((ByteBuffer)b, (long)l);
            String bufStr = Bytes.toStringBinary((byte[])b.array(), (int)b.arrayOffset(), (int)b.position());
            WritableUtils.writeVLong((DataOutput)dos, (long)l);
            String baosStr = Bytes.toStringBinary((byte[])baos.toByteArray());
            Assert.assertEquals((Object)baosStr, (Object)bufStr);
        }
    }

    @Test
    public void testMoveBufferToStream() throws IOException {
        int arrayOffset = 7;
        int initialPosition = 10;
        int endPadding = 5;
        byte[] arrayWrapper = new byte[17 + this.array.length + 5];
        System.arraycopy(this.array, 0, arrayWrapper, 17, this.array.length);
        ByteBuffer buffer = ByteBuffer.wrap(arrayWrapper, 7, 10 + this.array.length).slice();
        Assert.assertEquals((long)(10 + this.array.length), (long)buffer.limit());
        Assert.assertEquals((long)0L, (long)buffer.position());
        buffer.position(10);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteBufferUtils.moveBufferToStream((OutputStream)bos, (ByteBuffer)buffer, (int)this.array.length);
        Assert.assertArrayEquals((byte[])this.array, (byte[])bos.toByteArray());
        Assert.assertEquals((long)(10 + this.array.length), (long)buffer.position());
    }

    @Test
    public void testCopyToStreamWithOffset() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.array);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteBufferUtils.copyBufferToStream((OutputStream)bos, (ByteBuffer)buffer, (int)(this.array.length / 2), (int)(this.array.length / 2));
        byte[] returnedArray = bos.toByteArray();
        for (int i = 0; i < this.array.length / 2; ++i) {
            int pos = this.array.length / 2 + i;
            Assert.assertEquals((long)returnedArray[i], (long)this.array[pos]);
        }
    }

    @Test
    public void testCopyFromStream() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.array.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.array);
        DataInputStream dis = new DataInputStream(bis);
        ByteBufferUtils.copyFromStreamToBuffer((ByteBuffer)buffer, (DataInputStream)dis, (int)(this.array.length / 2));
        ByteBufferUtils.copyFromStreamToBuffer((ByteBuffer)buffer, (DataInputStream)dis, (int)(this.array.length - this.array.length / 2));
        for (int i = 0; i < this.array.length; ++i) {
            Assert.assertEquals((long)this.array[i], (long)buffer.get(i));
        }
    }

    @Test
    public void testCopyFromBuffer() {
        ByteBuffer srcBuffer = ByteBuffer.allocate(this.array.length);
        ByteBuffer dstBuffer = ByteBuffer.allocate(this.array.length);
        srcBuffer.put(this.array);
        ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)srcBuffer, (ByteBuffer)dstBuffer, (int)(this.array.length / 2), (int)(this.array.length / 4));
        for (int i = 0; i < this.array.length / 4; ++i) {
            Assert.assertEquals((long)srcBuffer.get(i + this.array.length / 2), (long)dstBuffer.get(i));
        }
    }

    @Test
    public void testCompressedInt() throws IOException {
        int i;
        this.testCompressedInt(0);
        this.testCompressedInt(Integer.MAX_VALUE);
        this.testCompressedInt(Integer.MIN_VALUE);
        for (i = 0; i < 3; ++i) {
            this.testCompressedInt((128 << i) - 1);
        }
        for (i = 0; i < 3; ++i) {
            this.testCompressedInt(128 << i);
        }
    }

    @Test
    public void testIntFitsIn() {
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.intFitsIn((int)0));
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.intFitsIn((int)1));
        Assert.assertEquals((long)2L, (long)ByteBufferUtils.intFitsIn((int)256));
        Assert.assertEquals((long)3L, (long)ByteBufferUtils.intFitsIn((int)65536));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)-1));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)Integer.MIN_VALUE));
    }

    @Test
    public void testLongFitsIn() {
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.longFitsIn((long)0L));
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.longFitsIn((long)1L));
        Assert.assertEquals((long)3L, (long)ByteBufferUtils.longFitsIn((long)65536L));
        Assert.assertEquals((long)5L, (long)ByteBufferUtils.longFitsIn((long)0x100000000L));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)-1L));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)Long.MIN_VALUE));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)Long.MAX_VALUE));
    }

    @Test
    public void testArePartEqual() {
        byte[] array = new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.wrap(array);
        Assert.assertTrue((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)0, (int)4, (int)5, (int)4));
        Assert.assertTrue((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)2, (int)6, (int)2));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)2, (int)6, (int)3));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)3, (int)6, (int)2));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)0, (int)3, (int)6, (int)3));
    }

    @Test
    public void testPutInt() {
        int i;
        this.testPutInt(0);
        this.testPutInt(Integer.MAX_VALUE);
        for (i = 0; i < 3; ++i) {
            this.testPutInt((128 << i) - 1);
        }
        for (i = 0; i < 3; ++i) {
            this.testPutInt(128 << i);
        }
    }

    private void testCompressedInt(int value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteBufferUtils.putCompressedInt((OutputStream)bos, (int)value);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        int parsedValue = ByteBufferUtils.readCompressedInt((InputStream)bis);
        Assert.assertEquals((long)value, (long)parsedValue);
    }

    private void testPutInt(int value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteBufferUtils.putInt((OutputStream)baos, (int)value);
        }
        catch (IOException e) {
            throw new RuntimeException("Bug in putIn()", e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        try {
            Assert.assertEquals((long)dis.readInt(), (long)value);
        }
        catch (IOException e) {
            throw new RuntimeException("Bug in test!", e);
        }
    }

    @Test
    public void testToBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((long)5L, (long)buffer.position());
        Assert.assertEquals((long)5L, (long)buffer.limit());
        byte[] copy = ByteBufferUtils.toBytes((ByteBuffer)buffer, (int)2);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])copy);
        Assert.assertEquals((long)5L, (long)buffer.position());
        Assert.assertEquals((long)5L, (long)buffer.limit());
    }

    @Test
    public void testToPrimitiveTypes() {
        ByteBuffer buffer = ByteBuffer.allocate(15);
        long l = 988L;
        int i = 135;
        short s = 7;
        buffer.putLong(l);
        buffer.putShort(s);
        buffer.putInt(i);
        Assert.assertEquals((long)l, (long)ByteBufferUtils.toLong((ByteBuffer)buffer, (int)0));
        Assert.assertEquals((long)s, (long)ByteBufferUtils.toShort((ByteBuffer)buffer, (int)8));
        Assert.assertEquals((long)i, (long)ByteBufferUtils.toInt((ByteBuffer)buffer, (int)10));
    }

    @Test
    public void testCopyFromArrayToBuffer() {
        byte[] b = new byte[15];
        b[0] = -1;
        long l = 988L;
        int i = 135;
        short s = 7;
        Bytes.putLong((byte[])b, (int)1, (long)l);
        Bytes.putShort((byte[])b, (int)9, (short)s);
        Bytes.putInt((byte[])b, (int)11, (int)i);
        ByteBuffer buffer = ByteBuffer.allocate(14);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buffer, (byte[])b, (int)1, (int)14);
        buffer.rewind();
        Assert.assertEquals((long)l, (long)buffer.getLong());
        Assert.assertEquals((long)s, (long)buffer.getShort());
        Assert.assertEquals((long)i, (long)buffer.getInt());
    }

    private void testCopyFromSrcToDestWithThreads(Object input, Object output, List<Integer> lengthes, List<Integer> offsets) throws InterruptedException {
        Assert.assertTrue((input instanceof ByteBuffer || input instanceof byte[] ? 1 : 0) != 0);
        Assert.assertTrue((output instanceof ByteBuffer || output instanceof byte[] ? 1 : 0) != 0);
        Assert.assertEquals((long)lengthes.size(), (long)offsets.size());
        int threads = lengthes.size();
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Runnable> exes = new ArrayList<Runnable>(threads);
        int oldInputPos = input instanceof ByteBuffer ? ((ByteBuffer)input).position() : 0;
        int oldOutputPos = output instanceof ByteBuffer ? ((ByteBuffer)output).position() : 0;
        for (int i = 0; i != threads; ++i) {
            int offset = offsets.get(i);
            int length = lengthes.get(i);
            exes.add(() -> {
                try {
                    latch.await();
                    if (input instanceof ByteBuffer && output instanceof byte[]) {
                        ByteBufferUtils.copyFromBufferToArray((byte[])((byte[])output), (ByteBuffer)((ByteBuffer)input), (int)offset, (int)offset, (int)length);
                    }
                    if (input instanceof byte[] && output instanceof ByteBuffer) {
                        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)((ByteBuffer)output), (int)offset, (byte[])((byte[])input), (int)offset, (int)length);
                    }
                    if (input instanceof ByteBuffer && output instanceof ByteBuffer) {
                        ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)((ByteBuffer)input), (ByteBuffer)((ByteBuffer)output), (int)offset, (int)offset, (int)length);
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        ExecutorService service = Executors.newFixedThreadPool(threads);
        exes.forEach(service::execute);
        latch.countDown();
        service.shutdown();
        Assert.assertTrue((boolean)service.awaitTermination(5L, TimeUnit.SECONDS));
        if (input instanceof ByteBuffer) {
            Assert.assertEquals((long)oldInputPos, (long)((ByteBuffer)input).position());
        }
        if (output instanceof ByteBuffer) {
            Assert.assertEquals((long)oldOutputPos, (long)((ByteBuffer)output).position());
        }
        String inputString = input instanceof ByteBuffer ? Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)((ByteBuffer)input))) : Bytes.toString((byte[])((byte[])input));
        String outputString = output instanceof ByteBuffer ? Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)((ByteBuffer)output))) : Bytes.toString((byte[])((byte[])output));
        Assert.assertEquals((Object)inputString, (Object)outputString);
    }

    @Test
    public void testCopyFromSrcToDestWithThreads() throws InterruptedException {
        List<byte[]> words = Arrays.asList(Bytes.toBytes((String)"with"), Bytes.toBytes((String)"great"), Bytes.toBytes((String)"power"), Bytes.toBytes((String)"comes"), Bytes.toBytes((String)"great"), Bytes.toBytes((String)"responsibility"));
        List<Integer> lengthes = words.stream().map(v -> ((byte[])v).length).collect(Collectors.toList());
        ArrayList<Integer> offsets = new ArrayList<Integer>(words.size());
        for (int i = 0; i != words.size(); ++i) {
            offsets.add(words.subList(0, i).stream().mapToInt(v -> ((byte[])v).length).sum());
        }
        int totalSize = words.stream().mapToInt(v -> ((byte[])v).length).sum();
        byte[] fullContent = new byte[totalSize];
        int offset = 0;
        for (byte[] w : words) {
            offset = Bytes.putBytes((byte[])fullContent, (int)offset, (byte[])w, (int)0, (int)w.length);
        }
        for (ByteBuffer input : Arrays.asList(ByteBuffer.allocateDirect(totalSize), ByteBuffer.allocate(totalSize))) {
            words.forEach(input::put);
            byte[] output = new byte[totalSize];
            this.testCopyFromSrcToDestWithThreads(input, output, lengthes, offsets);
        }
        for (ByteBuffer output : Arrays.asList(ByteBuffer.allocateDirect(totalSize), ByteBuffer.allocate(totalSize))) {
            byte[] input = fullContent;
            this.testCopyFromSrcToDestWithThreads(input, output, lengthes, offsets);
        }
        for (ByteBuffer input : Arrays.asList(ByteBuffer.allocateDirect(totalSize), ByteBuffer.allocate(totalSize))) {
            words.forEach(input::put);
            for (ByteBuffer output : Arrays.asList(ByteBuffer.allocateDirect(totalSize), ByteBuffer.allocate(totalSize))) {
                this.testCopyFromSrcToDestWithThreads(input, output, lengthes, offsets);
            }
        }
    }

    @Test
    public void testCopyFromBufferToArray() {
        ByteBuffer buffer = ByteBuffer.allocate(15);
        buffer.put((byte)-1);
        long l = 988L;
        int i = 135;
        short s = 7;
        buffer.putShort(s);
        buffer.putInt(i);
        buffer.putLong(l);
        byte[] b = new byte[15];
        ByteBufferUtils.copyFromBufferToArray((byte[])b, (ByteBuffer)buffer, (int)1, (int)1, (int)14);
        Assert.assertEquals((long)s, (long)Bytes.toShort((byte[])b, (int)1));
        Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])b, (int)3));
        Assert.assertEquals((long)l, (long)Bytes.toLong((byte[])b, (int)7));
    }

    @Test
    public void testRelativeCopyFromBuffertoBuffer() {
        ByteBuffer bb1 = ByteBuffer.allocate(135);
        ByteBuffer bb2 = ByteBuffer.allocate(135);
        TestByteBufferUtils.fillBB(bb1, (byte)5);
        ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)bb1, (ByteBuffer)bb2);
        Assert.assertTrue((bb1.position() == bb2.position() ? 1 : 0) != 0);
        Assert.assertTrue((bb1.limit() == bb2.limit() ? 1 : 0) != 0);
        bb1 = ByteBuffer.allocateDirect(135);
        bb2 = ByteBuffer.allocateDirect(135);
        TestByteBufferUtils.fillBB(bb1, (byte)5);
        ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)bb1, (ByteBuffer)bb2);
        Assert.assertTrue((bb1.position() == bb2.position() ? 1 : 0) != 0);
        Assert.assertTrue((bb1.limit() == bb2.limit() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        ByteBuffer bb1 = ByteBuffer.allocate(135);
        ByteBuffer bb2 = ByteBuffer.allocate(135);
        byte[] b = new byte[71];
        TestByteBufferUtils.fillBB(bb1, (byte)5);
        TestByteBufferUtils.fillBB(bb2, (byte)5);
        TestByteBufferUtils.fillArray(b, (byte)5);
        Assert.assertEquals((long)0L, (long)ByteBufferUtils.compareTo((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()));
        Assert.assertTrue((ByteBufferUtils.compareTo((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (byte[])b, (int)0, (int)b.length) > 0 ? 1 : 0) != 0);
        bb2.put(134, (byte)6);
        Assert.assertTrue((ByteBufferUtils.compareTo((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()) < 0 ? 1 : 0) != 0);
        bb2.put(6, (byte)4);
        Assert.assertTrue((ByteBufferUtils.compareTo((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()) > 0 ? 1 : 0) != 0);
        ByteBuffer bb3 = ByteBuffer.allocate(135);
        TestByteBufferUtils.fillBB(bb3, (byte)0);
        byte[] b3 = new byte[135];
        TestByteBufferUtils.fillArray(b3, (byte)1);
        int result = ByteBufferUtils.compareTo((byte[])b3, (int)0, (int)b3.length, (ByteBuffer)bb3, (int)0, (int)bb3.remaining());
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
        result = ByteBufferUtils.compareTo((ByteBuffer)bb3, (int)0, (int)bb3.remaining(), (byte[])b3, (int)0, (int)b3.length);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
        byte[] b4 = Bytes.toBytes((String)"123");
        ByteBuffer bb4 = ByteBuffer.allocate(10 + b4.length);
        for (int i = 10; i < bb4.capacity(); ++i) {
            bb4.put(i, b4[i - 10]);
        }
        result = ByteBufferUtils.compareTo((byte[])b4, (int)0, (int)b4.length, (ByteBuffer)bb4, (int)10, (int)b4.length);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testEquals() {
        byte[] a = Bytes.toBytes((String)"http://A");
        ByteBuffer bb = ByteBuffer.wrap(a);
        Assert.assertTrue((boolean)ByteBufferUtils.equals((ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)0, (ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)0));
        Assert.assertFalse((boolean)ByteBufferUtils.equals((ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)0, (ByteBuffer)bb, (int)0, (int)a.length));
        Assert.assertFalse((boolean)ByteBufferUtils.equals((ByteBuffer)bb, (int)0, (int)0, (ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)a.length));
        Assert.assertTrue((boolean)ByteBufferUtils.equals((ByteBuffer)bb, (int)0, (int)a.length, (ByteBuffer)bb, (int)0, (int)a.length));
        Assert.assertTrue((boolean)ByteBufferUtils.equals((ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)0, (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)0, (int)0));
        Assert.assertFalse((boolean)ByteBufferUtils.equals((ByteBuffer)HConstants.EMPTY_BYTE_BUFFER, (int)0, (int)0, (byte[])a, (int)0, (int)a.length));
        Assert.assertFalse((boolean)ByteBufferUtils.equals((ByteBuffer)bb, (int)0, (int)a.length, (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)0, (int)0));
        Assert.assertTrue((boolean)ByteBufferUtils.equals((ByteBuffer)bb, (int)0, (int)a.length, (byte[])a, (int)0, (int)a.length));
    }

    @Test
    public void testFindCommonPrefix() {
        ByteBuffer bb1 = ByteBuffer.allocate(135);
        ByteBuffer bb2 = ByteBuffer.allocate(135);
        ByteBuffer bb3 = ByteBuffer.allocateDirect(135);
        byte[] b = new byte[71];
        TestByteBufferUtils.fillBB(bb1, (byte)5);
        TestByteBufferUtils.fillBB(bb2, (byte)5);
        TestByteBufferUtils.fillBB(bb3, (byte)5);
        TestByteBufferUtils.fillArray(b, (byte)5);
        Assert.assertEquals((long)135L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()));
        Assert.assertEquals((long)71L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (byte[])b, (int)0, (int)b.length));
        Assert.assertEquals((long)135L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb3, (int)0, (int)bb3.remaining()));
        Assert.assertEquals((long)71L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb3, (int)0, (int)bb3.remaining(), (byte[])b, (int)0, (int)b.length));
        b[13] = 9;
        Assert.assertEquals((long)13L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (byte[])b, (int)0, (int)b.length));
        bb2.put(134, (byte)6);
        Assert.assertEquals((long)134L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()));
        bb2.put(6, (byte)4);
        Assert.assertEquals((long)6L, (long)ByteBufferUtils.findCommonPrefix((ByteBuffer)bb1, (int)0, (int)bb1.remaining(), (ByteBuffer)bb2, (int)0, (int)bb2.remaining()));
    }

    private static void fillBB(ByteBuffer bb, byte b) {
        for (int i = bb.position(); i < bb.limit(); ++i) {
            bb.put(i, b);
        }
    }

    private static void fillArray(byte[] bb, byte b) {
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = b;
        }
    }

    static {
        TreeSet<Long> a = new TreeSet<Long>();
        for (int i = 0; i <= 63; ++i) {
            long v = -1L << i;
            Assert.assertTrue((v < 0L ? 1 : 0) != 0);
            TestByteBufferUtils.addNumber(a, v);
            v = (1L << i) - 1L;
            Assert.assertTrue((v >= 0L ? 1 : 0) != 0);
            TestByteBufferUtils.addNumber(a, v);
        }
        testNumbers = Collections.unmodifiableSet(a);
        System.err.println("Testing variable-length long serialization using: " + testNumbers + " (count: " + testNumbers.size() + ")");
        Assert.assertEquals((long)1753L, (long)testNumbers.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((Long)a.first()));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((Long)a.last()));
    }
}

