/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class AsyncAggregationClient {
    private static <R, S, P extends Message, Q extends Message, T extends Message> R getCellValueFromProto(ColumnInterpreter<R, S, P, Q, T> ci, AggregateProtos.AggregateResponse resp, int firstPartIndex) throws IOException {
        Object q = AggregationHelper.getParsedGenericInstance(ci.getClass(), 3, resp.getFirstPart(firstPartIndex));
        return (R)ci.getCellValueFromProto(q);
    }

    private static <R, S, P extends Message, Q extends Message, T extends Message> S getPromotedValueFromProto(ColumnInterpreter<R, S, P, Q, T> ci, AggregateProtos.AggregateResponse resp, int firstPartIndex) throws IOException {
        Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, resp.getFirstPart(firstPartIndex));
        return (S)ci.getPromotedValueFromProto(t);
    }

    private static byte[] nullToEmpty(byte[] b) {
        return b != null ? b : HConstants.EMPTY_BYTE_ARRAY;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<R> max(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture future = new CompletableFuture();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback callback = new AbstractAggregationCallback<R>(future){
            private R max;

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    Object result = AsyncAggregationClient.getCellValueFromProto(ci, resp, 0);
                    if (this.max == null || result != null && ci.compare(this.max, result) < 0) {
                        this.max = result;
                    }
                }
            }

            @Override
            protected R getFinalResult() {
                return this.max;
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getMax(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<R> min(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture future = new CompletableFuture();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback callback = new AbstractAggregationCallback<R>(future){
            private R min;

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    Object result = AsyncAggregationClient.getCellValueFromProto(ci, resp, 0);
                    if (this.min == null || result != null && ci.compare(this.min, result) > 0) {
                        this.min = result;
                    }
                }
            }

            @Override
            protected R getFinalResult() {
                return this.min;
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getMin(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<Long> rowCount(AsyncTable<?> table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, true);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback<Long> callback = new AbstractAggregationCallback<Long>(future){
            private long count;

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                this.count += resp.getFirstPart(0).asReadOnlyByteBuffer().getLong();
            }

            @Override
            protected Long getFinalResult() {
                return this.count;
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getRowNum(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<S> sum(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture future = new CompletableFuture();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback callback = new AbstractAggregationCallback<S>(future){
            private S sum;

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    Object s = AsyncAggregationClient.getPromotedValueFromProto(ci, resp, 0);
                    this.sum = ci.add(this.sum, s);
                }
            }

            @Override
            protected S getFinalResult() {
                return this.sum;
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getSum(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<Double> avg(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture<Double> future = new CompletableFuture<Double>();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback<Double> callback = new AbstractAggregationCallback<Double>(future){
            private S sum;
            long count;
            {
                super(future);
                this.count = 0L;
            }

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    this.sum = ci.add(this.sum, AsyncAggregationClient.getPromotedValueFromProto(ci, resp, 0));
                    this.count += resp.getSecondPart().asReadOnlyByteBuffer().getLong();
                }
            }

            @Override
            protected Double getFinalResult() {
                return ci.divideForAvg(this.sum, Long.valueOf(this.count));
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getAvg(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<Double> std(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture<Double> future = new CompletableFuture<Double>();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        AbstractAggregationCallback<Double> callback = new AbstractAggregationCallback<Double>(future){
            private S sum;
            private S sumSq;
            private long count;

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    this.sum = ci.add(this.sum, AsyncAggregationClient.getPromotedValueFromProto(ci, resp, 0));
                    this.sumSq = ci.add(this.sumSq, AsyncAggregationClient.getPromotedValueFromProto(ci, resp, 1));
                    this.count += resp.getSecondPart().asReadOnlyByteBuffer().getLong();
                }
            }

            @Override
            protected Double getFinalResult() {
                double avg = ci.divideForAvg(this.sum, Long.valueOf(this.count));
                double avgSq = ci.divideForAvg(this.sumSq, Long.valueOf(this.count));
                return Math.sqrt(avgSq - avg * avg);
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getStd(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    private static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<NavigableMap<byte[], S>> sumByRegion(AsyncTable<?> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        AggregateProtos.AggregateRequest req;
        CompletableFuture<NavigableMap<byte[], S>> future = new CompletableFuture<NavigableMap<byte[], S>>();
        try {
            req = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
        final int firstPartIndex = ((NavigableSet)scan.getFamilyMap().get(scan.getFamilies()[0])).size() - 1;
        AbstractAggregationCallback callback = new AbstractAggregationCallback<NavigableMap<byte[], S>>(future){
            private final NavigableMap<byte[], S> map;
            {
                super(future);
                this.map = new TreeMap(Bytes.BYTES_COMPARATOR);
            }

            @Override
            protected void aggregate(RegionInfo region, AggregateProtos.AggregateResponse resp) throws IOException {
                if (resp.getFirstPartCount() > 0) {
                    this.map.put(region.getStartKey(), AsyncAggregationClient.getPromotedValueFromProto(ci, resp, firstPartIndex));
                }
            }

            @Override
            protected NavigableMap<byte[], S> getFinalResult() {
                return this.map;
            }
        };
        table.coprocessorService(AggregateProtos.AggregateService::newStub, (stub, controller, rpcCallback) -> stub.getMedian(controller, req, (RpcCallback<AggregateProtos.AggregateResponse>)rpcCallback), (AsyncTable.CoprocessorCallback)callback).fromRow(AsyncAggregationClient.nullToEmpty(scan.getStartRow()), scan.includeStartRow()).toRow(AsyncAggregationClient.nullToEmpty(scan.getStopRow()), scan.includeStopRow()).execute();
        return future;
    }

    private static <R, S, P extends Message, Q extends Message, T extends Message> void findMedian(final CompletableFuture<R> future, AsyncTable<AdvancedScanResultConsumer> table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan, NavigableMap<byte[], S> sumByRegion) {
        final double halfSum = ci.divideForAvg(sumByRegion.values().stream().reduce((arg_0, arg_1) -> ci.add(arg_0, arg_1)).get(), Long.valueOf(2L));
        Object movingSum = null;
        byte[] startRow = null;
        for (Map.Entry entry : sumByRegion.entrySet()) {
            startRow = (byte[])entry.getKey();
            Object newMovingSum = ci.add(movingSum, entry.getValue());
            if (ci.divideForAvg(newMovingSum, Long.valueOf(1L)) > halfSum) break;
            movingSum = newMovingSum;
        }
        if (startRow != null) {
            scan.withStartRow(startRow);
        }
        final Object baseSum = movingSum;
        final byte[] family = scan.getFamilies()[0];
        NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(family);
        final byte[] weightQualifier = (byte[])qualifiers.last();
        final byte[] valueQualifier = (byte[])qualifiers.first();
        table.scan(scan, (ScanResultConsumerBase)new AdvancedScanResultConsumer(){
            private S sum;
            private R value;
            {
                this.sum = baseSum;
                this.value = null;
            }

            public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
                try {
                    for (Result result : results) {
                        Cell weightCell = result.getColumnLatestCell(family, weightQualifier);
                        Object weight = ci.getValue(family, weightQualifier, weightCell);
                        this.sum = ci.add(this.sum, ci.castToReturnType(weight));
                        if (ci.divideForAvg(this.sum, Long.valueOf(1L)) > halfSum) {
                            if (this.value != null) {
                                future.complete(this.value);
                            } else {
                                future.completeExceptionally(new NoSuchElementException());
                            }
                            controller.terminate();
                            return;
                        }
                        Cell valueCell = result.getColumnLatestCell(family, valueQualifier);
                        this.value = ci.getValue(family, valueQualifier, valueCell);
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                    controller.terminate();
                }
            }

            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            public void onComplete() {
                if (!future.isDone()) {
                    future.completeExceptionally(new NoSuchElementException());
                }
            }
        });
    }

    public static <R, S, P extends Message, Q extends Message, T extends Message> CompletableFuture<R> median(AsyncTable<AdvancedScanResultConsumer> table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) {
        CompletableFuture future = new CompletableFuture();
        AsyncAggregationClient.sumByRegion(table, ci, scan).whenComplete((sumByRegion, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else if (sumByRegion.isEmpty()) {
                future.completeExceptionally(new NoSuchElementException());
            } else {
                AsyncAggregationClient.findMedian(future, table, ci, (Scan)ReflectionUtils.newInstance(scan.getClass(), (Object[])new Object[]{scan}), sumByRegion);
            }
        });
        return future;
    }

    private static abstract class AbstractAggregationCallback<T>
    implements AsyncTable.CoprocessorCallback<AggregateProtos.AggregateResponse> {
        private final CompletableFuture<T> future;
        protected boolean finished = false;

        private void completeExceptionally(Throwable error) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.future.completeExceptionally(error);
        }

        protected AbstractAggregationCallback(CompletableFuture<T> future) {
            this.future = future;
        }

        public synchronized void onRegionError(RegionInfo region, Throwable error) {
            this.completeExceptionally(error);
        }

        public synchronized void onError(Throwable error) {
            this.completeExceptionally(error);
        }

        protected abstract void aggregate(RegionInfo var1, AggregateProtos.AggregateResponse var2) throws IOException;

        public synchronized void onRegionComplete(RegionInfo region, AggregateProtos.AggregateResponse resp) {
            try {
                this.aggregate(region, resp);
            }
            catch (IOException e) {
                this.completeExceptionally(e);
            }
        }

        protected abstract T getFinalResult();

        public synchronized void onComplete() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.future.complete(this.getFinalResult());
        }
    }
}

