/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class MemcachedBlockCache
implements BlockCache {
    private static final Log LOG = LogFactory.getLog((String)MemcachedBlockCache.class.getName());
    public static final int MAX_SIZE = 1044480;
    public static final String MEMCACHED_CONFIG_KEY = "hbase.cache.memcached.servers";
    public static final String MEMCACHED_TIMEOUT_KEY = "hbase.cache.memcached.timeout";
    public static final String MEMCACHED_OPTIMEOUT_KEY = "hbase.cache.memcached.optimeout";
    public static final String MEMCACHED_OPTIMIZE_KEY = "hbase.cache.memcached.spy.optimze";
    public static final long MEMCACHED_DEFAULT_TIMEOUT = 500L;
    public static final boolean MEMCACHED_OPTIMIZE_DEFAULT = false;
    private final MemcachedClient client;
    private final HFileBlockTranscoder tc = new HFileBlockTranscoder();
    private final CacheStats cacheStats = new CacheStats("MemcachedBlockCache");

    public MemcachedBlockCache(Configuration c) throws IOException {
        LOG.info((Object)"Creating MemcachedBlockCache");
        long opTimeout = c.getLong(MEMCACHED_OPTIMEOUT_KEY, 500L);
        long queueTimeout = c.getLong(MEMCACHED_TIMEOUT_KEY, opTimeout + 500L);
        boolean optimize = c.getBoolean(MEMCACHED_OPTIMIZE_KEY, false);
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder().setOpTimeout(opTimeout).setOpQueueMaxBlockTime(queueTimeout).setFailureMode(FailureMode.Redistribute).setShouldOptimize(optimize).setDaemon(true).setUseNagleAlgorithm(false).setReadBufferSize(0x10000000);
        String serverListString = c.get(MEMCACHED_CONFIG_KEY, "localhost:11211");
        String[] servers = serverListString.split(",");
        ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(servers.length);
        for (String s : servers) {
            serverAddresses.add(Addressing.createInetSocketAddressFromHostAndPortStr((String)s));
        }
        this.client = new MemcachedClient(builder.build(), serverAddresses);
    }

    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory, boolean cacheDataInL1) {
        this.cacheBlock(cacheKey, buf);
    }

    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        if (buf instanceof HFileBlock) {
            this.client.add(cacheKey.toString(), 1044480, (Object)((HFileBlock)buf), (Transcoder)this.tc);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MemcachedBlockCache can not cache Cacheable's of type " + buf.getClass().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        HFileBlock result = null;
        try (TraceScope traceScope = Trace.startSpan((String)"MemcachedBlockCache.getBlock");){
            result = (HFileBlock)this.client.get(cacheKey.toString(), (Transcoder)this.tc);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exception pulling from memcached [ " + cacheKey.toString() + " ]. Treating as a miss."), (Throwable)e);
            }
            result = null;
        }
        finally {
            if (updateCacheMetrics) {
                if (result == null) {
                    this.cacheStats.miss(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
                } else {
                    this.cacheStats.hit(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
                }
            }
        }
        return result;
    }

    public boolean evictBlock(BlockCacheKey cacheKey) {
        block3: {
            try {
                this.cacheStats.evict();
                return (Boolean)this.client.delete(cacheKey.toString()).get();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Error deleting " + cacheKey.toString()), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("Error deleting " + cacheKey.toString()), (Throwable)e);
            }
        }
        return false;
    }

    public int evictBlocksByHfileName(String hfileName) {
        return 0;
    }

    public CacheStats getStats() {
        return this.cacheStats;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public long size() {
        return 0L;
    }

    public long getFreeSize() {
        return 0L;
    }

    public long getCurrentSize() {
        return 0L;
    }

    public long getBlockCount() {
        return 0L;
    }

    public Iterator<CachedBlock> iterator() {
        return new Iterator<CachedBlock>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public CachedBlock next() {
                throw new NoSuchElementException("MemcachedBlockCache can't iterate over blocks.");
            }

            @Override
            public void remove() {
            }
        };
    }

    public BlockCache[] getBlockCaches() {
        return null;
    }

    public void returnBlock(BlockCacheKey cacheKey, Cacheable block) {
    }

    private static class HFileBlockTranscoder
    implements Transcoder<HFileBlock> {
        private HFileBlockTranscoder() {
        }

        public boolean asyncDecode(CachedData d) {
            return false;
        }

        public CachedData encode(HFileBlock block) {
            ByteBuffer bb = ByteBuffer.allocate(block.getSerializedLength());
            block.serialize(bb);
            return new CachedData(0, bb.array(), 0x1400000);
        }

        public HFileBlock decode(CachedData d) {
            try {
                SingleByteBuff buf = new SingleByteBuff(ByteBuffer.wrap(d.getData()));
                return (HFileBlock)HFileBlock.BLOCK_DESERIALIZER.deserialize((ByteBuff)buf, true, Cacheable.MemoryType.EXCLUSIVE);
            }
            catch (IOException e) {
                LOG.warn((Object)"Error deserializing data from memcached", (Throwable)e);
                return null;
            }
        }

        public int getMaxSize() {
            return 1044480;
        }
    }
}

