/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilitySingletonFactory
extends CompatibilityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilitySingletonFactory.class);

    protected CompatibilitySingletonFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(Class<T> klass) {
        Object object = SingletonStorage.INSTANCE.lock;
        synchronized (object) {
            Object instance = SingletonStorage.INSTANCE.instances.get(klass);
            if (instance == null) {
                try {
                    ServiceLoader<T> loader = ServiceLoader.load(klass);
                    Iterator<T> it = loader.iterator();
                    instance = it.next();
                    if (it.hasNext()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("ServiceLoader provided more than one implementation for class: ").append(klass).append(", using implementation: ").append(instance.getClass()).append(", other implementations: {");
                        while (it.hasNext()) {
                            msg.append(it.next()).append(" ");
                        }
                        msg.append("}");
                        LOG.warn(msg.toString());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass), e);
                }
                catch (Error e) {
                    throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass), e);
                }
                if (instance == null) {
                    throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass));
                }
                SingletonStorage.INSTANCE.instances.put(klass, instance);
            }
            return (T)instance;
        }
    }

    public static enum SingletonStorage {
        INSTANCE;

        private final Object lock = new Object();
        private final Map<Class, Object> instances = new HashMap<Class, Object>();
    }
}

