/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.RandomStringGenerator;
import org.apache.hadoop.hbase.RandomStringGeneratorImpl;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestCompatibilitySingletonFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompatibilitySingletonFactory.class);
    private static final int ITERATIONS = 100000;

    @Test
    public void testGetInstance() throws Exception {
        ArrayList<TestCompatibilitySingletonFactoryCallable> callables = new ArrayList<TestCompatibilitySingletonFactoryCallable>(100000);
        ArrayList resultStrings = new ArrayList(100000);
        for (int i = 0; i < 100000; ++i) {
            callables.add(new TestCompatibilitySingletonFactoryCallable());
        }
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        List futures = executorService.invokeAll(callables);
        for (Future f : futures) {
            resultStrings.add(f.get());
        }
        String firstString = (String)resultStrings.get(0);
        for (String s : resultStrings) {
            Assert.assertEquals((Object)firstString, (Object)s);
        }
        Assert.assertNotEquals((Object)new RandomStringGeneratorImpl().getRandString(), (Object)firstString);
    }

    private class TestCompatibilitySingletonFactoryCallable
    implements Callable<String> {
        private TestCompatibilitySingletonFactoryCallable() {
        }

        @Override
        public String call() throws Exception {
            Thread.sleep(10L);
            RandomStringGenerator instance = (RandomStringGenerator)CompatibilitySingletonFactory.getInstance(RandomStringGenerator.class);
            return instance.getRandString();
        }
    }
}

