/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.impl.GlobalMetricRegistriesAdapter;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestGlobalMetricRegistriesAdapter {
    @Test
    public void testUnregisterSource() {
        GlobalMetricRegistriesAdapter adapter = GlobalMetricRegistriesAdapter.init();
        adapter.stop();
        TestSource ts1 = new TestSource("ts1");
        TestSource ts2 = new TestSource("ts2");
        MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
        metricsSystem.register("ts1", "", (Object)ts1);
        metricsSystem.register("ts2", "", (Object)ts2);
        MetricsSource s1 = metricsSystem.getSource("ts1");
        Assert.assertNotNull((Object)s1);
        MetricRegistryInfo mockRegistryInfo = (MetricRegistryInfo)Mockito.mock(MetricRegistryInfo.class);
        Mockito.when((Object)mockRegistryInfo.getMetricsJmxContext()).thenReturn((Object)"ts1");
        adapter.unregisterSource(mockRegistryInfo);
        s1 = metricsSystem.getSource("ts1");
        Assert.assertNull((Object)s1);
        MetricsSource s2 = metricsSystem.getSource("ts2");
        Assert.assertNotNull((Object)s2);
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        @Metric(value={"XXX desc"})
        MutableCounterLong xxx;
        @Metric(value={"G1 desc"})
        MutableGaugeLong g1;
        @Metric(value={"YYY desc"})
        MutableGaugeLong yyy;
        @Metric
        MutableRate s1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }
    }
}

