/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsSnapshotSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;

@InterfaceAudience.Private
public class MetricsSnapshotSourceImpl
extends BaseSourceImpl
implements MetricsSnapshotSource {
    private MetricHistogram snapshotTimeHisto;
    private MetricHistogram snapshotCloneTimeHisto;
    private MetricHistogram snapshotRestoreTimeHisto;

    public MetricsSnapshotSourceImpl() {
        this("Snapshots", "Metrics about HBase master server", "master", "Master,sub=Snapshots");
    }

    public MetricsSnapshotSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.snapshotTimeHisto = this.metricsRegistry.newTimeHistogram("snapshotTime", "Time it takes to finish snapshot()");
        this.snapshotCloneTimeHisto = this.metricsRegistry.newTimeHistogram("snapshotCloneTime", "Time it takes to finish cloneSnapshot()");
        this.snapshotRestoreTimeHisto = this.metricsRegistry.newTimeHistogram("snapshotRestoreTime", "Time it takes to finish restoreSnapshot()");
    }

    public void updateSnapshotTime(long time) {
        this.snapshotTimeHisto.add(time);
    }

    public void updateSnapshotCloneTime(long time) {
        this.snapshotCloneTimeHisto.add(time);
    }

    public void updateSnapshotRestoreTime(long time) {
        this.snapshotRestoreTimeHisto.add(time);
    }
}

