/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.io.MetricsIOSource;
import org.apache.hadoop.hbase.io.MetricsIOSourceImpl;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManagerSource;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManagerSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.hbase.regionserver.MetricsUserSourceImpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsRegionServerSourceFactoryImpl
implements MetricsRegionServerSourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MetricsRegionAggregateSourceImpl getRegionAggregate() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.regionAggImpl == null) {
                FactoryStorage.INSTANCE.regionAggImpl = new MetricsRegionAggregateSourceImpl();
            }
            return FactoryStorage.INSTANCE.regionAggImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetricsUserAggregateSourceImpl getUserAggregate() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.userAggImpl == null) {
                FactoryStorage.INSTANCE.userAggImpl = new MetricsUserAggregateSourceImpl();
            }
            return FactoryStorage.INSTANCE.userAggImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetricsTableAggregateSourceImpl getTableAggregate() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.tblAggImpl == null) {
                FactoryStorage.INSTANCE.tblAggImpl = new MetricsTableAggregateSourceImpl();
            }
            return FactoryStorage.INSTANCE.tblAggImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetricsHeapMemoryManagerSource getHeapMemoryManager() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.heapMemMngImpl == null) {
                FactoryStorage.INSTANCE.heapMemMngImpl = new MetricsHeapMemoryManagerSourceImpl();
            }
            return FactoryStorage.INSTANCE.heapMemMngImpl;
        }
    }

    public synchronized MetricsRegionServerSource createServer(MetricsRegionServerWrapper regionServerWrapper) {
        return new MetricsRegionServerSourceImpl(regionServerWrapper);
    }

    public MetricsRegionSource createRegion(MetricsRegionWrapper wrapper) {
        return new MetricsRegionSourceImpl(wrapper, this.getRegionAggregate());
    }

    public MetricsTableSource createTable(String table, MetricsTableWrapperAggregate wrapper) {
        return new MetricsTableSourceImpl(table, this.getTableAggregate(), wrapper);
    }

    public MetricsIOSource createIO(MetricsIOWrapper wrapper) {
        return new MetricsIOSourceImpl(wrapper);
    }

    public MetricsUserSource createUser(String shortUserName) {
        return new MetricsUserSourceImpl(shortUserName, this.getUserAggregate());
    }

    public static enum FactoryStorage {
        INSTANCE;

        private final Object aggLock = new Object();
        private MetricsRegionAggregateSourceImpl regionAggImpl;
        private MetricsUserAggregateSourceImpl userAggImpl;
        private MetricsTableAggregateSourceImpl tblAggImpl;
        private MetricsHeapMemoryManagerSourceImpl heapMemMngImpl;
    }
}

