/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.impl.TerminalImpl;

@InterfaceAudience.Private
public class Screen
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Screen.class);
    private static final long SLEEP_TIMEOUT_MILLISECONDS = 100L;
    private final Connection connection;
    private final Admin admin;
    private final Terminal terminal;
    private ScreenView currentScreenView;
    private Long timerTimestamp;

    public Screen(Configuration conf, long initialRefreshDelay, Mode initialMode) throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = this.connection.getAdmin();
        this.terminal = new TerminalImpl("hbtop");
        this.currentScreenView = new TopScreenView(this, this.terminal, initialRefreshDelay, this.admin, initialMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.admin.close();
        }
        finally {
            try {
                this.connection.close();
            }
            finally {
                this.terminal.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.currentScreenView.init();
        while (true) {
            try {
                while (true) {
                    ScreenView nextScreenView;
                    block11: {
                        KeyPress keyPress;
                        if ((keyPress = this.terminal.pollKeyPress()) != null) {
                            nextScreenView = this.currentScreenView.handleKeyPress(keyPress);
                        } else {
                            if (this.timerTimestamp != null) {
                                long now = System.currentTimeMillis();
                                if (this.timerTimestamp <= now) {
                                    this.timerTimestamp = null;
                                    nextScreenView = this.currentScreenView.handleTimer();
                                    break block11;
                                } else {
                                    if (this.timerTimestamp - now < 100L) {
                                        TimeUnit.MILLISECONDS.sleep(this.timerTimestamp - now);
                                        continue;
                                    }
                                    TimeUnit.MILLISECONDS.sleep(100L);
                                    continue;
                                }
                            }
                            TimeUnit.MILLISECONDS.sleep(100L);
                            continue;
                        }
                    }
                    if (nextScreenView == null) {
                        return;
                    }
                    if (nextScreenView == this.currentScreenView) continue;
                    this.currentScreenView = nextScreenView;
                    this.currentScreenView.init();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Caught an exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setTimer(long delay) {
        this.timerTimestamp = System.currentTimeMillis() + delay;
    }

    public void cancelTimer() {
        this.timerTimestamp = null;
    }
}

