/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class RequestCountPerSecond {
    private long previousLastReportTimestamp;
    private long previousReadRequestCount;
    private long previousWriteRequestCount;
    private long readRequestCountPerSecond;
    private long writeRequestCountPerSecond;

    public void refresh(long lastReportTimestamp, long readRequestCount, long writeRequestCount) {
        if (this.previousLastReportTimestamp == 0L) {
            this.previousLastReportTimestamp = lastReportTimestamp;
            this.previousReadRequestCount = readRequestCount;
            this.previousWriteRequestCount = writeRequestCount;
        } else if (this.previousLastReportTimestamp != lastReportTimestamp) {
            long delta = (lastReportTimestamp - this.previousLastReportTimestamp) / 1000L;
            if (delta < 1L) {
                delta = 1L;
            }
            this.readRequestCountPerSecond = (readRequestCount - this.previousReadRequestCount) / delta;
            this.writeRequestCountPerSecond = (writeRequestCount - this.previousWriteRequestCount) / delta;
            this.previousLastReportTimestamp = lastReportTimestamp;
            this.previousReadRequestCount = readRequestCount;
            this.previousWriteRequestCount = writeRequestCount;
        }
    }

    public long getReadRequestCountPerSecond() {
        return this.readRequestCountPerSecond < 0L ? 0L : this.readRequestCountPerSecond;
    }

    public long getWriteRequestCountPerSecond() {
        return this.writeRequestCountPerSecond < 0L ? 0L : this.writeRequestCountPerSecond;
    }

    public long getRequestCountPerSecond() {
        return this.getReadRequestCountPerSecond() + this.getWriteRequestCountPerSecond();
    }
}

