/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;

@InterfaceAudience.Private
public class TopScreenModel {
    private static final Log LOG = LogFactory.getLog(TopScreenModel.class);
    private final Admin admin;
    private Mode currentMode;
    private Field currentSortField;
    private List<FieldInfo> fieldInfos;
    private List<Field> fields;
    private Summary summary;
    private List<Record> records;
    private final List<RecordFilter> filters = new ArrayList<RecordFilter>();
    private final List<String> filterHistories = new ArrayList<String>();
    private boolean ascendingSort;

    public TopScreenModel(Admin admin, Mode initialMode, @Nullable List<Field> initialFields, @Nullable Field initialSortField, @Nullable Boolean initialAscendingSort, @Nullable List<RecordFilter> initialFilters) {
        this.admin = Objects.requireNonNull(admin);
        this.switchMode(Objects.requireNonNull(initialMode), initialSortField, false, initialFields, initialAscendingSort, initialFilters);
    }

    public void switchMode(Mode nextMode, boolean keepSortFieldAndSortOrderIfPossible, List<RecordFilter> initialFilters) {
        this.switchMode(nextMode, null, keepSortFieldAndSortOrderIfPossible, null, null, initialFilters);
    }

    public void switchMode(Mode nextMode, Field initialSortField, boolean keepSortFieldAndSortOrderIfPossible, @Nullable List<Field> initialFields, @Nullable Boolean initialAscendingSort, @Nullable List<RecordFilter> initialFilters) {
        this.currentMode = nextMode;
        this.fieldInfos = Collections.unmodifiableList(new ArrayList<FieldInfo>(this.currentMode.getFieldInfos()));
        this.fields = new ArrayList<Field>();
        for (FieldInfo fieldInfo : this.currentMode.getFieldInfos()) {
            if (initialFields != null) {
                if (!initialFields.contains((Object)fieldInfo.getField())) continue;
                this.fields.add(fieldInfo.getField());
                continue;
            }
            this.fields.add(fieldInfo.getField());
        }
        this.fields = Collections.unmodifiableList(this.fields);
        if (keepSortFieldAndSortOrderIfPossible) {
            boolean match = false;
            for (Field field : this.fields) {
                if (field != this.currentSortField) continue;
                match = true;
                break;
            }
            if (!match) {
                if (initialSortField != null && initialAscendingSort != null) {
                    this.currentSortField = initialSortField;
                    this.ascendingSort = initialAscendingSort;
                } else {
                    this.currentSortField = nextMode.getDefaultSortField();
                    this.ascendingSort = false;
                }
            }
        } else if (initialSortField != null && initialAscendingSort != null) {
            this.currentSortField = initialSortField;
            this.ascendingSort = initialAscendingSort;
        } else {
            this.currentSortField = nextMode.getDefaultSortField();
            this.ascendingSort = false;
        }
        this.clearFilters();
        if (initialFilters != null) {
            this.filters.addAll(initialFilters);
        }
    }

    public void setSortFieldAndFields(Field sortField, List<Field> fields) {
        this.currentSortField = sortField;
        this.fields = Collections.unmodifiableList(new ArrayList<Field>(fields));
    }

    public void refreshMetricsData() {
        ClusterStatus clusterStatus;
        try {
            clusterStatus = this.admin.getClusterStatus();
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to get cluster status", (Throwable)e);
            return;
        }
        this.refreshSummary(clusterStatus);
        this.refreshRecords(clusterStatus);
    }

    private void refreshSummary(ClusterStatus clusterStatus) {
        String currentTime = DateFormatUtils.ISO_8601_EXTENDED_TIME_FORMAT.format(System.currentTimeMillis());
        String version = clusterStatus.getHBaseVersion();
        String clusterId = clusterStatus.getClusterId();
        int liveServers = clusterStatus.getServersSize();
        int deadServers = clusterStatus.getDeadServerNames().size();
        int regionCount = clusterStatus.getRegionsCount();
        int ritCount = clusterStatus.getRegionsInTransition().size();
        double averageLoad = clusterStatus.getAverageLoad();
        long aggregateRequestPerSecond = 0L;
        for (ServerName sn : clusterStatus.getServers()) {
            ServerLoad sl = clusterStatus.getLoad(sn);
            aggregateRequestPerSecond += sl.getNumberOfRequests();
        }
        this.summary = new Summary(currentTime, version, clusterId, liveServers + deadServers, liveServers, deadServers, regionCount, ritCount, averageLoad, aggregateRequestPerSecond);
    }

    private void refreshRecords(ClusterStatus clusterStatus) {
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record record : this.currentMode.getRecords(clusterStatus)) {
            boolean filter = false;
            for (RecordFilter recordFilter : this.filters) {
                if (recordFilter.execute(record)) continue;
                filter = true;
                break;
            }
            if (filter) continue;
            records.add(record);
        }
        Collections.sort(records, new Comparator<Record>(){

            @Override
            public int compare(Record recordLeft, Record recordRight) {
                FieldValue left = recordLeft.get((Object)TopScreenModel.this.currentSortField);
                FieldValue right = recordRight.get((Object)TopScreenModel.this.currentSortField);
                return (TopScreenModel.this.ascendingSort ? 1 : -1) * left.compareTo(right);
            }
        });
        this.records = Collections.unmodifiableList(records);
    }

    public void switchSortOrder() {
        this.ascendingSort = !this.ascendingSort;
    }

    public boolean addFilter(String filterString, boolean ignoreCase) {
        RecordFilter filter = RecordFilter.parse(filterString, this.fields, ignoreCase);
        if (filter == null) {
            return false;
        }
        this.filters.add(filter);
        this.filterHistories.add(filterString);
        return true;
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public boolean drillDown(Record selectedRecord) {
        DrillDownInfo drillDownInfo = this.currentMode.drillDown(selectedRecord);
        if (drillDownInfo == null) {
            return false;
        }
        this.switchMode(drillDownInfo.getNextMode(), true, drillDownInfo.getInitialFilters());
        return true;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public Field getCurrentSortField() {
        return this.currentSortField;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public List<RecordFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public List<String> getFilterHistories() {
        return Collections.unmodifiableList(this.filterHistories);
    }
}

