/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class CompactTableAction
extends Action {
    private final byte[] tableNameBytes;
    private final int majorRatio;
    private final long sleepTime;
    private final String tableName;

    public CompactTableAction(String tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactTableAction(int sleepTime, String tableName, float majorRatio) {
        this.tableNameBytes = Bytes.toBytes((String)tableName);
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        boolean major = RandomUtils.nextInt((int)100) < this.majorRatio;
        LOG.info((Object)("Performing action: Compact table " + this.tableName + ", major=" + major));
        try {
            if (major) {
                admin.majorCompact(this.tableNameBytes);
            } else {
                admin.compact(this.tableNameBytes);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Compaction failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

