/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.junit.Assert;

public class UnbalanceKillAndRebalanceAction
extends Action {
    private static final double FRC_SERVERS_THAT_HOARD_AND_LIVE = 0.1;
    private static final double FRC_SERVERS_THAT_HOARD_AND_DIE = 0.1;
    private static final double HOARD_FRC_OF_REGIONS = 0.8;
    private long waitForUnbalanceMilliSec;
    private long waitForKillsMilliSec;
    private long waitAfterBalanceMilliSec;

    public UnbalanceKillAndRebalanceAction(long waitUnbalance, long waitKill, long waitAfterBalance) {
        this.waitForUnbalanceMilliSec = waitUnbalance;
        this.waitForKillsMilliSec = waitKill;
        this.waitAfterBalanceMilliSec = waitAfterBalance;
    }

    @Override
    public void perform() throws Exception {
        int i;
        int deadCount;
        ClusterStatus status = this.cluster.getClusterStatus();
        LinkedList<ServerName> victimServers = new LinkedList<ServerName>(status.getServers());
        int liveCount = (int)Math.ceil(0.1 * (double)victimServers.size());
        Assert.assertTrue((liveCount + (deadCount = (int)Math.ceil(0.1 * (double)victimServers.size())) < victimServers.size() ? 1 : 0) != 0);
        ArrayList<ServerName> targetServers = new ArrayList<ServerName>(liveCount);
        for (i = 0; i < liveCount + deadCount; ++i) {
            int victimIx = RandomUtils.nextInt((int)victimServers.size());
            targetServers.add((ServerName)victimServers.remove(victimIx));
        }
        this.unbalanceRegions(status, victimServers, targetServers, 0.8);
        Thread.sleep(this.waitForUnbalanceMilliSec);
        for (i = 0; i < liveCount; ++i) {
            this.killRs((ServerName)targetServers.get(i));
        }
        Thread.sleep(this.waitForKillsMilliSec);
        this.forceBalancer();
        Thread.sleep(this.waitAfterBalanceMilliSec);
        for (i = 0; i < liveCount; ++i) {
            this.startRs((ServerName)targetServers.get(i));
        }
    }
}

