/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicPolicy;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;

public class PeriodicRandomActionPolicy
extends PeriodicPolicy {
    private List<Pair<Action, Integer>> actions;

    public PeriodicRandomActionPolicy(long periodMs, List<Pair<Action, Integer>> actions) {
        super(periodMs);
        this.actions = actions;
    }

    public PeriodicRandomActionPolicy(long periodMs, Pair<Action, Integer> ... actions) {
        this(periodMs, Arrays.asList(actions));
    }

    public PeriodicRandomActionPolicy(long periodMs, Action ... actions) {
        super(periodMs);
        this.actions = new ArrayList<Pair<Action, Integer>>(actions.length);
        for (Action action : actions) {
            this.actions.add((Pair<Action, Integer>)new Pair((Object)action, (Object)1));
        }
    }

    @Override
    protected void runOneIteration() {
        Action action = (Action)PolicyBasedChaosMonkey.selectWeightedRandomItem(this.actions);
        try {
            action.perform();
        }
        catch (Exception ex) {
            LOG.warn((Object)("Exception occured during performing action: " + StringUtils.stringifyException((Throwable)ex)));
        }
    }

    @Override
    public void init(Policy.PolicyContext context) throws Exception {
        super.init(context);
        for (Pair<Action, Integer> action : this.actions) {
            ((Action)action.getFirst()).init(this.context);
        }
    }
}

