/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;

public class RestartRsHoldingMetaAction
extends RestartActionBaseAction {
    public RestartRsHoldingMetaAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    public void perform() throws Exception {
        LOG.info((Object)"Performing action: Restart region server holding META");
        ServerName server = this.cluster.getServerHoldingMeta();
        if (server == null) {
            LOG.warn((Object)"No server is holding hbase:meta right now.");
            return;
        }
        ClusterStatus clusterStatus = this.cluster.getClusterStatus();
        if (server.equals((Object)clusterStatus.getMaster())) {
            this.restartMaster(server, this.sleepTime);
        } else {
            this.restartRs(server, this.sleepTime);
        }
    }
}

