/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class DistributedHBaseCluster
extends HBaseCluster {
    private Admin admin;
    private final Connection connection;
    private ClusterManager clusterManager;

    public DistributedHBaseCluster(Configuration conf, ClusterManager clusterManager) throws IOException {
        super(conf);
        this.clusterManager = clusterManager;
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = this.connection.getAdmin();
        this.initialClusterStatus = this.getClusterStatus();
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.admin.getClusterStatus();
    }

    public ClusterStatus getInitialClusterStatus() throws IOException {
        return this.initialClusterStatus;
    }

    public void close() throws IOException {
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName serverName) throws IOException {
        return ((ClusterConnection)this.connection).getAdmin(serverName);
    }

    public ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName serverName) throws IOException {
        return ((ClusterConnection)this.connection).getClient(serverName);
    }

    public void startRegionServer(String hostname, int port) throws IOException {
        LOG.info((Object)("Starting RS on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname, port);
    }

    public void killRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting RS: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public void stopRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping RS: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName, timeout);
    }

    public void startZkNode(String hostname, int port) throws IOException {
        LOG.info((Object)("Starting Zookeeper node on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.ZOOKEEPER_SERVER, hostname, port);
    }

    public void killZkNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting Zookeeper node on: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName.getHostname(), serverName.getPort());
    }

    public void stopZkNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping Zookeeper node: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForZkNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName, timeout);
    }

    public void waitForZkNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName, timeout);
    }

    public void startDataNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Starting data node on: " + serverName.getServerName()));
        this.clusterManager.start(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void killDataNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting data node on: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void stopDataNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping data node on: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void waitForDataNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.HADOOP_DATANODE, serverName, timeout);
    }

    public void waitForDataNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HADOOP_DATANODE, serverName, timeout);
    }

    public void startNameNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Starting name node on: " + serverName.getServerName()));
        this.clusterManager.start(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void killNameNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting name node on: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void stopNameNode(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping name node on: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void waitForNameNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName, timeout);
    }

    public void waitForNameNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName, timeout);
    }

    private void waitForServiceToStop(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info((Object)("Waiting for service: " + (Object)((Object)service) + " to stop: " + serverName.getServerName()));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.clusterManager.isRunning(service, serverName.getHostname(), serverName.getPort())) {
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("did timeout waiting for service to stop:" + serverName);
    }

    private void waitForServiceToStart(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info((Object)("Waiting for service: " + (Object)((Object)service) + " to start: " + serverName.getServerName()));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (this.clusterManager.isRunning(service, serverName.getHostname(), serverName.getPort())) {
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("did timeout waiting for service to start:" + serverName);
    }

    public MasterProtos.MasterService.BlockingInterface getMasterAdminService() throws IOException {
        return ((ClusterConnection)this.connection).getMaster();
    }

    public void startMaster(String hostname, int port) throws IOException {
        LOG.info((Object)("Starting Master on: " + hostname + ":" + port));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_MASTER, hostname, port);
    }

    public void killMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting Master: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname(), serverName.getPort());
    }

    public void stopMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping Master: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_MASTER, serverName, timeout);
    }

    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                this.getMasterAdminService();
                return true;
            }
            catch (MasterNotRunningException m) {
                LOG.warn((Object)("Master not started yet " + (Object)((Object)m)));
            }
            catch (ZooKeeperConnectionException e) {
                LOG.warn((Object)("Failed to connect to ZK " + (Object)((Object)e)));
            }
            Threads.sleep((long)1000L);
        }
        return false;
    }

    public ServerName getServerHoldingRegion(TableName tn, byte[] regionName) throws IOException {
        HRegionLocation regionLoc = null;
        try (RegionLocator locator = this.connection.getRegionLocator(tn);){
            regionLoc = locator.getRegionLocation(regionName, true);
        }
        if (regionLoc == null) {
            LOG.warn((Object)("Cannot find region server holding region " + Bytes.toString((byte[])regionName) + ", start key [" + Bytes.toString((byte[])HRegionInfo.getStartKey((byte[])regionName)) + "]"));
            return null;
        }
        AdminProtos.AdminService.BlockingInterface client = ((ClusterConnection)this.connection).getAdmin(regionLoc.getServerName());
        AdminProtos.ServerInfo info = ProtobufUtil.getServerInfo(null, (AdminProtos.AdminService.BlockingInterface)client);
        return ProtobufUtil.toServerName((HBaseProtos.ServerName)info.getServerName());
    }

    public void waitUntilShutDown() {
        throw new RuntimeException("Not implemented yet");
    }

    public void shutdown() throws IOException {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isDistributedCluster() {
        return true;
    }

    public boolean restoreClusterStatus(ClusterStatus initial) throws IOException {
        ClusterStatus current = this.getClusterStatus();
        LOG.info((Object)"Restoring cluster - started");
        boolean success = true;
        success = this.restoreMasters(initial, current) & success;
        success = this.restoreRegionServers(initial, current) & success;
        success = this.restoreAdmin() & success;
        LOG.info((Object)"Restoring cluster - done");
        return success;
    }

    protected boolean restoreMasters(ClusterStatus initial, ClusterStatus current) {
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        ServerName initMaster = initial.getMaster();
        if (!ServerName.isSameHostnameAndPort((ServerName)initMaster, (ServerName)current.getMaster())) {
            LOG.info((Object)("Restoring cluster - Initial active master : " + initMaster.getHostAndPort() + " has changed to : " + current.getMaster().getHostAndPort()));
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, initMaster.getHostname(), initMaster.getPort())) {
                    LOG.info((Object)("Restoring cluster - starting initial active master at:" + initMaster.getHostAndPort()));
                    this.startMaster(initMaster.getHostname(), initMaster.getPort());
                }
                for (ServerName currentBackup : current.getBackupMasters()) {
                    if (ServerName.isSameHostnameAndPort((ServerName)currentBackup, (ServerName)initMaster)) continue;
                    LOG.info((Object)("Restoring cluster - stopping backup master: " + currentBackup));
                    this.stopMaster(currentBackup);
                }
                LOG.info((Object)("Restoring cluster - stopping active master: " + current.getMaster()));
                this.stopMaster(current.getMaster());
                this.waitForActiveAndReadyMaster();
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
            for (ServerName backup : initial.getBackupMasters()) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, backup.getHostname(), backup.getPort())) continue;
                    LOG.info((Object)("Restoring cluster - starting initial backup master: " + backup.getHostAndPort()));
                    this.startMaster(backup.getHostname(), backup.getPort());
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        } else {
            TreeSet<ServerName> toStart = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
            TreeSet<ServerName> toKill = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
            toStart.addAll(initial.getBackupMasters());
            toKill.addAll(current.getBackupMasters());
            for (ServerName server : current.getBackupMasters()) {
                toStart.remove(server);
            }
            for (ServerName server : initial.getBackupMasters()) {
                toKill.remove(server);
            }
            for (ServerName sn : toStart) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, sn.getHostname(), sn.getPort())) continue;
                    LOG.info((Object)("Restoring cluster - starting initial backup master: " + sn.getHostAndPort()));
                    this.startMaster(sn.getHostname(), sn.getPort());
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
            for (ServerName sn : toKill) {
                try {
                    if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, sn.getHostname(), sn.getPort())) continue;
                    LOG.info((Object)("Restoring cluster - stopping backup master: " + sn.getHostAndPort()));
                    this.stopMaster(sn);
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn((Object)("Restoring cluster - restoring region servers reported " + deferred.size() + " errors:"));
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(deferred.get(i));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreRegionServers(ClusterStatus initial, ClusterStatus current) {
        TreeSet<ServerName> toStart = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
        TreeSet<ServerName> toKill = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
        toStart.addAll(initial.getServers());
        toKill.addAll(current.getServers());
        for (ServerName server : current.getServers()) {
            toStart.remove(server);
        }
        for (ServerName server : initial.getServers()) {
            toKill.remove(server);
        }
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        for (ServerName sn : toStart) {
            try {
                if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, sn.getHostname(), sn.getPort())) continue;
                LOG.info((Object)("Restoring cluster - starting initial region server: " + sn.getHostAndPort()));
                this.startRegionServer(sn.getHostname(), sn.getPort());
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        for (ServerName sn : toKill) {
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, sn.getHostname(), sn.getPort())) continue;
                LOG.info((Object)("Restoring cluster - stopping initial region server: " + sn.getHostAndPort()));
                this.stopRegionServer(sn);
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn((Object)("Restoring cluster - restoring region servers reported " + deferred.size() + " errors:"));
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(deferred.get(i));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreAdmin() throws IOException {
        try {
            this.admin.close();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"While closing the old connection", (Throwable)ioe);
        }
        this.admin = this.connection.getAdmin();
        LOG.info((Object)"Added new HBaseAdmin");
        return true;
    }

    private static class ServerNameIgnoreStartCodeComparator
    implements Comparator<ServerName> {
        private ServerNameIgnoreStartCodeComparator() {
        }

        @Override
        public int compare(ServerName o1, ServerName o2) {
            int compare = o1.getHostname().compareToIgnoreCase(o2.getHostname());
            if (compare != 0) {
                return compare;
            }
            compare = o1.getPort() - o2.getPort();
            if (compare != 0) {
                return compare;
            }
            return 0;
        }
    }
}

