/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TestAcidGuarantees;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestAcidGuarantees
extends IntegrationTestBase {
    private static final int SERVER_COUNT = 1;
    TestAcidGuarantees tag;

    @Override
    public int runTestFromCommandLine() throws Exception {
        Configuration c = this.getConf();
        int millis = c.getInt("millis", 5000);
        int numWriters = c.getInt("numWriters", 50);
        int numGetters = c.getInt("numGetters", 2);
        int numScanners = c.getInt("numScanners", 2);
        int numUniqueRows = c.getInt("numUniqueRows", 3);
        this.tag.runTestAtomicity((long)millis, numWriters, numGetters, numScanners, numUniqueRows, true);
        return 0;
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(1);
        this.conf = this.getConf();
        this.conf.set("hbase.hregion.memstore.flush.size", String.valueOf(131072));
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        this.setConf(this.util.getConfiguration());
        this.tag = new TestAcidGuarantees();
        this.tag.setHBaseTestingUtil((HBaseTestingUtility)this.util);
    }

    @Override
    public TableName getTablename() {
        return TestAcidGuarantees.TABLE_NAME;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])TestAcidGuarantees.FAMILY_A), Bytes.toString((byte[])TestAcidGuarantees.FAMILY_B), Bytes.toString((byte[])TestAcidGuarantees.FAMILY_C)});
    }

    @Test
    public void testGetAtomicity() throws Exception {
        this.tag.runTestAtomicity(20000L, 4, 4, 0, 3);
    }

    @Test
    public void testScanAtomicity() throws Exception {
        this.tag.runTestAtomicity(20000L, 3, 0, 2, 3);
    }

    @Test
    public void testMixedAtomicity() throws Exception {
        this.tag.runTestAtomicity(20000L, 4, 2, 2, 3);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestAcidGuarantees(), (String[])args);
        System.exit(ret);
    }
}

