/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CoprocClusterManager
extends HBaseClusterManager {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocClusterManager.class);
    private static final Set<ClusterManager.ServiceType> supportedServices = CoprocClusterManager.buildSupportedServicesSet();

    @Override
    protected Pair<Integer, String> exec(String hostname, ClusterManager.ServiceType service, String ... cmd) throws IOException {
        if (!supportedServices.contains((Object)service)) {
            throw CoprocClusterManager.unsupportedServiceType(service);
        }
        String command = StringUtils.join((Object[])cmd, (String)" ");
        LOG.info(String.format("Executing remote command: %s, hostname:%s", command, hostname));
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());){
            ShellExecEndpoint.ShellExecResponse resp;
            Admin admin = conn.getAdmin();
            ShellExecEndpoint.ShellExecRequest req = ShellExecEndpoint.ShellExecRequest.newBuilder().setCommand(command).setAwaitResponse(false).build();
            try {
                switch (service) {
                    case HBASE_MASTER: {
                        resp = CoprocClusterManager.masterExec(admin, req);
                        break;
                    }
                    case HBASE_REGIONSERVER: {
                        ServerName targetHost = CoprocClusterManager.resolveRegionServerName(admin, hostname);
                        resp = CoprocClusterManager.regionServerExec(admin, req, targetHost);
                        break;
                    }
                    default: {
                        throw new RuntimeException("should not happen");
                    }
                }
            }
            catch (ServiceException se) {
                LOG.error(String.format("Error running command: %s, error: %s", command, se.getMessage()));
                throw new IOException(se);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Executed remote command: %s, exit code:%s , output:%s", command, resp.getExitCode(), resp.getStdout()));
            } else {
                LOG.info(String.format("Executed remote command: %s, exit code:%s", command, resp.getExitCode()));
            }
            Pair pair = new Pair((Object)resp.getExitCode(), (Object)resp.getStdout());
            return pair;
        }
    }

    private static Set<ClusterManager.ServiceType> buildSupportedServicesSet() {
        HashSet<ClusterManager.ServiceType> set = new HashSet<ClusterManager.ServiceType>();
        set.add(ClusterManager.ServiceType.HBASE_MASTER);
        set.add(ClusterManager.ServiceType.HBASE_REGIONSERVER);
        return Collections.unmodifiableSet(set);
    }

    private static ShellExecEndpoint.ShellExecResponse masterExec(Admin admin, ShellExecEndpoint.ShellExecRequest req) throws ServiceException {
        return ShellExecEndpoint.ShellExecService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService()).shellExec((RpcController)new HBaseRpcControllerImpl(), req);
    }

    private static ShellExecEndpoint.ShellExecResponse regionServerExec(Admin admin, ShellExecEndpoint.ShellExecRequest req, ServerName targetHost) throws ServiceException {
        return ShellExecEndpoint.ShellExecService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService(targetHost)).shellExec((RpcController)new HBaseRpcControllerImpl(), req);
    }

    private static ServerName resolveRegionServerName(Admin admin, String hostname) throws IOException {
        Collection liveServers = admin.getClusterStatus().getServers();
        for (ServerName sname : liveServers) {
            if (!sname.getServerName().equals(hostname)) continue;
            return sname;
        }
        throw CoprocClusterManager.serverNotFound(hostname);
    }

    private static RuntimeException serverNotFound(String hostname) {
        return new RuntimeException(String.format("Did not find %s amongst the servers known to the client.", hostname));
    }

    private static RuntimeException unsupportedServiceType(ClusterManager.ServiceType serviceType) {
        return new RuntimeException(String.format("Unable to service request for service=%s", new Object[]{serviceType}));
    }
}

