/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeBloomFilterAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;
    private static final Logger LOG = LoggerFactory.getLogger(ChangeBloomFilterAction.class);

    public ChangeBloomFilterAction(TableName tableName) {
        this(-1, tableName);
    }

    public ChangeBloomFilterAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        Random random = new Random();
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        this.getLogger().info("Performing action: Change bloom filter on all columns of table " + this.tableName);
        HTableDescriptor tableDescriptor = admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        BloomType[] bloomArray = BloomType.values();
        int bloomArraySize = bloomArray.length;
        for (HColumnDescriptor descriptor : columnDescriptors) {
            int bloomFilterIndex = random.nextInt(bloomArraySize);
            this.getLogger().debug("Performing action: About to set bloom filter type to " + bloomArray[bloomFilterIndex] + " on column " + descriptor.getNameAsString() + " of table " + this.tableName);
            descriptor.setBloomFilterType(bloomArray[bloomFilterIndex]);
            this.getLogger().debug("Performing action: Just set bloom filter type to " + bloomArray[bloomFilterIndex] + " on column " + descriptor.getNameAsString() + " of table " + this.tableName);
        }
        if (this.context.isStopping()) {
            return;
        }
        admin.modifyTable(this.tableName, tableDescriptor);
    }
}

