/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartActionBaseAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(RestartActionBaseAction.class);
    long sleepTime;

    public RestartActionBaseAction(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    void sleep(long sleepTime) {
        this.getLogger().info("Sleeping for:" + sleepTime);
        Threads.sleep((long)sleepTime);
    }

    void restartMaster(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Killing master: " + server);
        this.killMaster(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting master: " + server);
        this.startMaster(server);
    }

    void gracefulRestartRs(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Stopping region server: " + server);
        this.stopRs(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting region server: " + server);
        this.startRs(server);
    }

    void restartRs(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Killing region server: " + server);
        this.killRs(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting region server: " + server);
        this.startRs(server);
    }

    void restartZKNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Killing zookeeper node: " + server);
        this.killZKNode(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting zookeeper node: " + server);
        this.startZKNode(server);
    }

    void restartDataNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Killing data node: " + server);
        this.killDataNode(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting data node: " + server);
        this.startDataNode(server);
    }

    void restartNameNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Killing name node: " + server);
        this.killNameNode(server);
        this.sleep(sleepTime);
        this.getLogger().info("Starting name node: " + server);
        this.startNameNode(server);
    }
}

