/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRsHoldingMetaAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartRsHoldingMetaAction.class);

    public RestartRsHoldingMetaAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Restart region server holding META");
        ServerName server = this.cluster.getServerHoldingMeta();
        if (server == null) {
            this.getLogger().warn("No server is holding hbase:meta right now.");
            return;
        }
        ClusterStatus clusterStatus = this.cluster.getClusterStatus();
        if (server.equals((Object)clusterStatus.getMaster())) {
            this.restartMaster(server, this.sleepTime);
        } else {
            this.restartRs(server, this.sleepTime);
        }
    }
}

