/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.AddColumnAction;
import org.apache.hadoop.hbase.chaos.actions.BatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeSplitPolicyAction;
import org.apache.hadoop.hbase.chaos.actions.CompactRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.CompactTableAction;
import org.apache.hadoop.hbase.chaos.actions.DecreaseMaxHFileSizeAction;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.FlushRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.FlushTableAction;
import org.apache.hadoop.hbase.chaos.actions.MergeRandomAdjacentRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.MoveRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.MoveRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.RemoveColumnAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRsHoldingMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchSuspendResumeRsAction;
import org.apache.hadoop.hbase.chaos.actions.SplitAllRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.SplitRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.CompositeSequentialPolicy;
import org.apache.hadoop.hbase.chaos.policies.DoActionsOncePolicy;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class StressAssignmentManagerMonkeyFactory
extends MonkeyFactory {
    private long rollingBatchSuspendRSSleepTime;
    private float rollingBatchSuspendtRSRatio;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new CompactTableAction(this.tableName, 0.5f), new CompactRandomRegionOfTableAction(this.tableName, 0.6f), new FlushTableAction(this.tableName), new FlushRandomRegionOfTableAction(this.tableName)};
        Action[] actions2 = new Action[]{new SplitRandomRegionOfTableAction(this.tableName), new MergeRandomAdjacentRegionsOfTableAction(this.tableName), new AddColumnAction(this.tableName), new RemoveColumnAction(this.tableName, this.columnFamilies), new MoveRegionsOfTableAction(800L, 1600L, this.tableName), new MoveRandomRegionOfTableAction(800L, this.tableName), new RestartRandomRsAction(60000L), new BatchRestartRsAction(5000L, 0.5f), new RollingBatchRestartRsAction(5000L, 1.0f), new RestartRsHoldingMetaAction(35000L), new ChangeSplitPolicyAction(this.tableName), new SplitAllRegionOfTableAction(this.tableName), new DecreaseMaxHFileSizeAction(30000L, this.tableName), new RollingBatchSuspendResumeRsAction(this.rollingBatchSuspendRSSleepTime, this.rollingBatchSuspendtRSRatio)};
        Action[] actions3 = new Action[]{new DumpClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.util, new PeriodicRandomActionPolicy(90000L, actions1), new CompositeSequentialPolicy(new DoActionsOncePolicy(90000L, actions2), new PeriodicRandomActionPolicy(90000L, actions2)), new PeriodicRandomActionPolicy(90000L, actions3));
    }

    private void loadProperties() {
        this.rollingBatchSuspendRSSleepTime = Long.parseLong(this.properties.getProperty("rolling.batch.restart.rs.sleep.time", "5000"));
        this.rollingBatchSuspendtRSRatio = Float.parseFloat(this.properties.getProperty("rolling.batch.restart.rs.ratio", "1.0"));
    }
}

