/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.rsgroup.VerifyingRSGroupAdminClient;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestRSGroup
extends TestRSGroupsBase {
    private static final Log LOG = LogFactory.getLog(IntegrationTestRSGroup.class);
    private static boolean initialized = false;

    @Before
    public void beforeMethod() throws Exception {
        if (!initialized) {
            LOG.info((Object)"Setting up IntegrationTestGroup");
            LOG.info((Object)"Initializing cluster with 4 servers");
            TEST_UTIL = new IntegrationTestingUtility();
            TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
            TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
            ((IntegrationTestingUtility)TEST_UTIL).initializeCluster(4);
            admin = TEST_UTIL.getHBaseAdmin();
            cluster = TEST_UTIL.getHBaseClusterInterface();
            rsGroupAdmin = new VerifyingRSGroupAdminClient((RSGroupAdmin)new RSGroupAdminClient(TEST_UTIL.getConnection()), TEST_UTIL.getConfiguration());
            LOG.info((Object)"Done initializing cluster");
            initialized = true;
            this.afterMethod();
        }
    }

    @After
    public void afterMethod() throws Exception {
        LOG.info((Object)"Cleaning up previous test run");
        this.deleteTableIfNecessary();
        this.deleteNamespaceIfNecessary();
        this.deleteGroups();
        admin.setBalancerRunning(true, true);
        LOG.info((Object)"Restoring the cluster");
        ((IntegrationTestingUtility)TEST_UTIL).restoreCluster();
        LOG.info((Object)"Done restoring the cluster");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info((Object)("Waiting for cleanup to finish " + TestRSGroupsBase.rsGroupAdmin.listRSGroups()));
                return TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size() >= 4;
            }
        });
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info((Object)("Waiting for regionservers to be registered " + TestRSGroupsBase.rsGroupAdmin.listRSGroups()));
                return TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size() == IntegrationTestRSGroup.this.getNumServers();
            }
        });
        LOG.info((Object)"Done cleaning up previous test run");
    }
}

