/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactType;

public class CompactMobAction
extends Action {
    private final TableName tableName;
    private final int majorRatio;
    private final long sleepTime;

    public CompactMobAction(TableName tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactMobAction(int sleepTime, TableName tableName, float majorRatio) {
        this.tableName = tableName;
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        boolean major;
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        boolean bl = major = RandomUtils.nextInt((int)0, (int)100) < this.majorRatio;
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Performing action: Compact mob of table " + this.tableName + ", major=" + major);
        try {
            if (major) {
                admin.majorCompact(this.tableName, CompactType.MOB);
            } else {
                admin.compact(this.tableName, CompactType.MOB);
            }
        }
        catch (Exception ex) {
            LOG.warn("Mob Compaction failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

