/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;

public class DecreaseMaxHFileSizeAction
extends Action {
    private static final long minFileSize = 0x40000000L;
    private final long sleepTime;
    private final TableName tableName;
    private final Random random;
    private Admin admin;

    public DecreaseMaxHFileSizeAction(long sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getAdmin();
    }

    @Override
    public void perform() throws Exception {
        TableDescriptor td = this.admin.getDescriptor(this.tableName);
        long currentValue = td.getMaxFileSize();
        if (currentValue <= 0L) {
            currentValue = this.context.getHBaseCluster().getConf().getLong("hbase.hregion.max.filesize", 0x280000000L);
        }
        long newValue = (long)((double)currentValue * 0.9);
        newValue = Math.max(0x40000000L, newValue) - (long)(512 - this.random.nextInt(1024));
        TableDescriptor modifiedTable = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setMaxFileSize(newValue).build();
        if (this.context.isStopping()) {
            return;
        }
        this.admin.modifyTable(modifiedTable);
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

