/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;

public class MergeRandomAdjacentRegionsOfTableAction
extends Action {
    private final TableName tableName;
    private final long sleepTime;

    public MergeRandomAdjacentRegionsOfTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public MergeRandomAdjacentRegionsOfTableAction(int sleepTime, TableName tableName) {
        this.tableName = tableName;
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        LOG.info("Performing action: Merge random adjacent regions of table " + this.tableName);
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.size() < 2) {
            LOG.info("Table " + this.tableName + " doesn't have enough regions to merge");
            return;
        }
        int i = RandomUtils.nextInt((int)0, (int)(regions.size() - 1));
        HRegionInfo a = (HRegionInfo)regions.get(i++);
        HRegionInfo b = (HRegionInfo)regions.get(i);
        LOG.debug("Merging " + a.getRegionNameAsString() + " and " + b.getRegionNameAsString());
        if (this.context.isStopping()) {
            return;
        }
        try {
            admin.mergeRegionsAsync(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false);
        }
        catch (Exception ex) {
            LOG.warn("Merge failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

