/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.util.Threads;

public class RestartActionBaseAction
extends Action {
    long sleepTime;

    public RestartActionBaseAction(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    void sleep(long sleepTime) {
        LOG.info("Sleeping for:" + sleepTime);
        Threads.sleep((long)sleepTime);
    }

    void restartMaster(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.killMaster(server);
        this.sleep(sleepTime);
        this.startMaster(server);
    }

    void restartRs(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.killRs(server);
        this.sleep(sleepTime);
        this.startRs(server);
    }

    void restartZKNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.killZKNode(server);
        this.sleep(sleepTime);
        this.startZKNode(server);
    }

    void restartDataNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        this.killDataNode(server);
        this.sleep(sleepTime);
        this.startDataNode(server);
    }
}

