/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;

public abstract class Action {
    public static final String KILL_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.killmastertimeout";
    public static final String START_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.startmastertimeout";
    public static final String KILL_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.killrstimeout";
    public static final String START_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.startrstimeout";
    public static final String KILL_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killzknodetimeout";
    public static final String START_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startzknodetimeout";
    public static final String KILL_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killdatanodetimeout";
    public static final String START_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startdatanodetimeout";
    public static final String KILL_NAMENODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killnamenodetimeout";
    public static final String START_NAMENODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startnamenodetimeout";
    protected static final long KILL_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_NAMENODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_NAMENODE_TIMEOUT_DEFAULT = 60000L;
    protected ActionContext context;
    protected HBaseCluster cluster;
    protected ClusterMetrics initialStatus;
    protected ServerName[] initialServers;
    protected Properties monkeyProps;
    protected long killMasterTimeout;
    protected long startMasterTimeout;
    protected long killRsTimeout;
    protected long startRsTimeout;
    protected long killZkNodeTimeout;
    protected long startZkNodeTimeout;
    protected long killDataNodeTimeout;
    protected long startDataNodeTimeout;
    protected long killNameNodeTimeout;
    protected long startNameNodeTimeout;
    protected boolean skipMetaRS;

    protected abstract Logger getLogger();

    public void init(ActionContext context) throws IOException {
        this.context = context;
        this.cluster = context.getHBaseCluster();
        this.initialStatus = this.cluster.getInitialClusterMetrics();
        Set regionServers = this.initialStatus.getLiveServerMetrics().keySet();
        this.initialServers = regionServers.toArray(new ServerName[0]);
        this.monkeyProps = context.getMonkeyProps();
        if (this.monkeyProps == null) {
            this.monkeyProps = new Properties();
            IntegrationTestBase.loadMonkeyProperties(this.monkeyProps, this.cluster.getConf());
        }
        this.killMasterTimeout = Long.parseLong(this.monkeyProps.getProperty(KILL_MASTER_TIMEOUT_KEY, "60000"));
        this.startMasterTimeout = Long.parseLong(this.monkeyProps.getProperty(START_MASTER_TIMEOUT_KEY, "60000"));
        this.killRsTimeout = Long.parseLong(this.monkeyProps.getProperty(KILL_RS_TIMEOUT_KEY, "60000"));
        this.startRsTimeout = Long.parseLong(this.monkeyProps.getProperty(START_RS_TIMEOUT_KEY, "60000"));
        this.killZkNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(KILL_ZK_NODE_TIMEOUT_KEY, "60000"));
        this.startZkNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(START_ZK_NODE_TIMEOUT_KEY, "60000"));
        this.killDataNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(KILL_DATANODE_TIMEOUT_KEY, "60000"));
        this.startDataNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(START_DATANODE_TIMEOUT_KEY, "60000"));
        this.killNameNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(KILL_NAMENODE_TIMEOUT_KEY, "60000"));
        this.startNameNodeTimeout = Long.parseLong(this.monkeyProps.getProperty(START_NAMENODE_TIMEOUT_KEY, "60000"));
        this.skipMetaRS = Boolean.parseBoolean(this.monkeyProps.getProperty("skip.meta.rs", "false"));
    }

    public void perform() throws Exception {
    }

    protected ServerName[] getCurrentServers() throws IOException {
        ClusterMetrics clusterStatus = this.cluster.getClusterMetrics();
        Set regionServers = clusterStatus.getLiveServerMetrics().keySet();
        int count = regionServers.size();
        if (count <= 0) {
            return new ServerName[0];
        }
        ServerName master = clusterStatus.getMasterName();
        HashSet<ServerName> masters = new HashSet<ServerName>();
        masters.add(master);
        masters.addAll(clusterStatus.getBackupMasterNames());
        ArrayList tmp = new ArrayList(count);
        tmp.addAll(regionServers);
        tmp.removeAll(masters);
        if (this.skipMetaRS) {
            ServerName metaServer = this.cluster.getServerHoldingMeta();
            tmp.remove(metaServer);
        }
        return tmp.toArray(new ServerName[0]);
    }

    protected void killMaster(ServerName server) throws IOException {
        this.getLogger().info("Killing master {}", (Object)server);
        this.cluster.killMaster(server);
        this.cluster.waitForMasterToStop(server, this.killMasterTimeout);
        this.getLogger().info("Killed master " + server);
    }

    protected void startMaster(ServerName server) throws IOException {
        this.getLogger().info("Starting master {}", (Object)server.getHostname());
        this.cluster.startMaster(server.getHostname(), server.getPort());
        this.cluster.waitForActiveAndReadyMaster(this.startMasterTimeout);
        this.getLogger().info("Started master " + server.getHostname());
    }

    protected void stopRs(ServerName server) throws IOException {
        this.getLogger().info("Stopping regionserver {}", (Object)server);
        this.cluster.stopRegionServer(server);
        this.cluster.waitForRegionServerToStop(server, this.killRsTimeout);
        this.getLogger().info("Stopping regionserver {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void suspendRs(ServerName server) throws IOException {
        this.getLogger().info("Suspending regionserver {}", (Object)server);
        this.cluster.suspendRegionServer(server);
        if (!(this.cluster instanceof MiniHBaseCluster)) {
            this.cluster.waitForRegionServerToStop(server, this.killRsTimeout);
        }
        this.getLogger().info("Suspending regionserver {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void resumeRs(ServerName server) throws IOException {
        this.getLogger().info("Resuming regionserver {}", (Object)server);
        this.cluster.resumeRegionServer(server);
        if (!(this.cluster instanceof MiniHBaseCluster)) {
            this.cluster.waitForRegionServerToStart(server.getHostname(), server.getPort(), this.startRsTimeout);
        }
        this.getLogger().info("Resuming regionserver {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void killRs(ServerName server) throws IOException {
        this.getLogger().info("Killing regionserver {}", (Object)server);
        this.cluster.killRegionServer(server);
        this.cluster.waitForRegionServerToStop(server, this.killRsTimeout);
        this.getLogger().info("Killed regionserver {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startRs(ServerName server) throws IOException {
        this.getLogger().info("Starting regionserver {}", (Object)server.getAddress());
        this.cluster.startRegionServer(server.getHostname(), server.getPort());
        this.cluster.waitForRegionServerToStart(server.getHostname(), server.getPort(), this.startRsTimeout);
        this.getLogger().info("Started regionserver {}. Reported num of rs:{}", (Object)server.getAddress(), (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void killZKNode(ServerName server) throws IOException {
        this.getLogger().info("Killing zookeeper node {}", (Object)server);
        this.cluster.killZkNode(server);
        this.cluster.waitForZkNodeToStop(server, this.killZkNodeTimeout);
        this.getLogger().info("Killed zookeeper node {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startZKNode(ServerName server) throws IOException {
        this.getLogger().info("Starting zookeeper node {}", (Object)server.getHostname());
        this.cluster.startZkNode(server.getHostname(), server.getPort());
        this.cluster.waitForZkNodeToStart(server, this.startZkNodeTimeout);
        this.getLogger().info("Started zookeeper node {}", (Object)server);
    }

    protected void killDataNode(ServerName server) throws IOException {
        this.getLogger().info("Killing datanode {}", (Object)server);
        this.cluster.killDataNode(server);
        this.cluster.waitForDataNodeToStop(server, this.killDataNodeTimeout);
        this.getLogger().info("Killed datanode {}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startDataNode(ServerName server) throws IOException {
        this.getLogger().info("Starting datanode {}", (Object)server.getHostname());
        this.cluster.startDataNode(server);
        this.cluster.waitForDataNodeToStart(server, this.startDataNodeTimeout);
        this.getLogger().info("Started datanode {}", (Object)server);
    }

    protected void killNameNode(ServerName server) throws IOException {
        this.getLogger().info("Killing namenode :-{}", (Object)server.getHostname());
        this.cluster.killNameNode(server);
        this.cluster.waitForNameNodeToStop(server, this.killNameNodeTimeout);
        this.getLogger().info("Killed namenode:{}. Reported num of rs:{}", (Object)server, (Object)this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startNameNode(ServerName server) throws IOException {
        this.getLogger().info("Starting Namenode :-{}", (Object)server.getHostname());
        this.cluster.startNameNode(server);
        this.cluster.waitForNameNodeToStart(server, this.startNameNodeTimeout);
        this.getLogger().info("Started namenode:{}", (Object)server);
    }

    protected void unbalanceRegions(ClusterMetrics clusterStatus, List<ServerName> fromServers, List<ServerName> toServers, double fractionOfRegions) throws Exception {
        LinkedList<byte[]> victimRegions = new LinkedList<byte[]>();
        for (Map.Entry entry : clusterStatus.getLiveServerMetrics().entrySet()) {
            ServerName sn = (ServerName)entry.getKey();
            ServerMetrics serverLoad = (ServerMetrics)entry.getValue();
            LinkedList regions = new LinkedList(serverLoad.getRegionMetrics().keySet());
            int victimRegionCount = (int)Math.ceil(fractionOfRegions * (double)regions.size());
            this.getLogger().debug("Removing {} regions from {}", (Object)victimRegionCount, (Object)sn);
            for (int i = 0; i < victimRegionCount; ++i) {
                int victimIx = RandomUtils.nextInt((int)0, (int)regions.size());
                String regionId = HRegionInfo.encodeRegionName((byte[])((byte[])regions.remove(victimIx)));
                victimRegions.add(Bytes.toBytes((String)regionId));
            }
        }
        this.getLogger().info("Moving {} regions from {} servers to {} different servers", new Object[]{victimRegions.size(), fromServers.size(), toServers.size()});
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        for (byte[] victimRegion : victimRegions) {
            if (this.context.isStopping()) break;
            int targetIx = RandomUtils.nextInt((int)0, (int)toServers.size());
            admin.move(victimRegion, toServers.get(targetIx));
        }
    }

    protected void forceBalancer() throws Exception {
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        boolean result = false;
        try {
            result = admin.balancer();
        }
        catch (Exception e) {
            this.getLogger().warn("Got exception while doing balance ", (Throwable)e);
        }
        if (!result) {
            this.getLogger().error("Balancer didn't succeed");
        }
    }

    protected void setBalancer(boolean onOrOff, boolean synchronous) throws Exception {
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        try {
            admin.balancerSwitch(onOrOff, synchronous);
        }
        catch (Exception e) {
            this.getLogger().warn("Got exception while switching balance ", (Throwable)e);
        }
    }

    public Configuration getConf() {
        return this.cluster.getConf();
    }

    protected void modifyAllTableColumns(TableName tableName, BiConsumer<String, ColumnFamilyDescriptorBuilder> transform) throws IOException {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        TableDescriptor tableDescriptor = admin.getDescriptor(tableName);
        ColumnFamilyDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
        for (ColumnFamilyDescriptor descriptor : columnDescriptors) {
            ColumnFamilyDescriptorBuilder cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)descriptor);
            transform.accept(descriptor.getNameAsString(), cfd);
            builder.modifyColumnFamily(cfd.build());
        }
        if (this.context.isStopping()) {
            return;
        }
        admin.modifyTable(builder.build());
    }

    protected void modifyAllTableColumns(TableName tableName, Consumer<ColumnFamilyDescriptorBuilder> transform) throws IOException {
        this.modifyAllTableColumns(tableName, (String name, ColumnFamilyDescriptorBuilder cfd) -> transform.accept((ColumnFamilyDescriptorBuilder)cfd));
    }

    public static class ActionContext {
        private IntegrationTestingUtility util;
        private Properties monkeyProps = null;

        public ActionContext(IntegrationTestingUtility util) {
            this.util = util;
        }

        public ActionContext(Properties monkeyProps, IntegrationTestingUtility util) {
            this.util = util;
            this.monkeyProps = monkeyProps;
        }

        public Properties getMonkeyProps() {
            return this.monkeyProps;
        }

        public IntegrationTestingUtility getHBaseIntegrationTestingUtility() {
            return this.util;
        }

        public HBaseCluster getHBaseCluster() {
            return this.util.getHBaseClusterInterface();
        }

        public boolean isStopping() {
            return false;
        }
    }
}

