/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRandomAdjacentRegionsOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(MergeRandomAdjacentRegionsOfTableAction.class);
    private final TableName tableName;
    private final long sleepTime;

    public MergeRandomAdjacentRegionsOfTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public MergeRandomAdjacentRegionsOfTableAction(int sleepTime, TableName tableName) {
        this.tableName = tableName;
        this.sleepTime = sleepTime;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        this.getLogger().info("Performing action: Merge random adjacent regions of table " + this.tableName);
        List regions = admin.getRegions(this.tableName);
        if (regions == null || regions.size() < 2) {
            this.getLogger().info("Table " + this.tableName + " doesn't have enough regions to merge");
            return;
        }
        int i = RandomUtils.nextInt((int)0, (int)(regions.size() - 1));
        RegionInfo a = (RegionInfo)regions.get(i++);
        RegionInfo b = (RegionInfo)regions.get(i);
        this.getLogger().debug("Merging " + a.getRegionNameAsString() + " and " + b.getRegionNameAsString());
        if (this.context.isStopping()) {
            return;
        }
        try {
            admin.mergeRegionsAsync(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false);
        }
        catch (Exception ex) {
            this.getLogger().warn("Merge failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

