/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRandomDataNodeAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartRandomDataNodeAction.class);

    public RestartRandomDataNodeAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Restart random data node");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getDataNodes());
        this.restartDataNode(server, this.sleepTime);
    }

    public ServerName[] getDataNodes() throws IOException {
        DistributedFileSystem fs = (DistributedFileSystem)CommonFSUtils.getRootDir((Configuration)this.getConf()).getFileSystem(this.getConf());
        DFSClient dfsClient = fs.getClient();
        LinkedList<ServerName> hosts = new LinkedList<ServerName>();
        for (DatanodeInfo dataNode : dfsClient.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)) {
            hosts.add(ServerName.valueOf((String)dataNode.getHostName(), (int)-1, (long)-1L));
        }
        return hosts.toArray(new ServerName[0]);
    }
}

